/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.template.engine.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.IOException;
import top.redscorpion.core.io.FileUtil;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.template.Template;
import top.redscorpion.template.TemplateConfig;
import top.redscorpion.template.TemplateEngine;
import top.redscorpion.template.TemplateException;
import top.redscorpion.template.engine.freemarker.FreemarkerTemplate;
import top.redscorpion.template.engine.freemarker.SimpleStringTemplateLoader;

public class FreemarkerEngine
implements TemplateEngine {
    private Configuration cfg;

    public FreemarkerEngine() {
    }

    public FreemarkerEngine(TemplateConfig config) {
        this.init(config);
    }

    public FreemarkerEngine(Configuration freemarkerCfg) {
        this.init(freemarkerCfg);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.init(FreemarkerEngine.createCfg(config));
        return this;
    }

    private void init(Configuration freemarkerCfg) {
        this.cfg = freemarkerCfg;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.cfg) {
            this.init(TemplateConfig.DEFAULT);
        }
        try {
            return FreemarkerTemplate.wrap(this.cfg.getTemplate(resource));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    private static Configuration createCfg(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setLocalizedLookup(false);
        cfg.setDefaultEncoding(config.getCharset().toString());
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(RsClass.getClassLoader(), config.getPath()));
                break;
            }
            case FILE: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file(config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
            case WEB_ROOT: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file(FileUtil.getWebRoot(), config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
            case STRING: {
                cfg.setTemplateLoader((TemplateLoader)new SimpleStringTemplateLoader());
                break;
            }
        }
        return cfg;
    }
}

