/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.template.engine.beetl;

import java.io.IOException;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.CompositeResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.core.resource.WebAppResourceLoader;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.template.Template;
import top.redscorpion.template.TemplateConfig;
import top.redscorpion.template.TemplateEngine;
import top.redscorpion.template.engine.beetl.BeetlTemplate;

public class BeetlEngine
implements TemplateEngine {
    private GroupTemplate engine;

    public BeetlEngine() {
    }

    public BeetlEngine(TemplateConfig config) {
        this.init(config);
    }

    public BeetlEngine(GroupTemplate engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        this.init(BeetlEngine.createEngine(config));
        return this;
    }

    private void init(GroupTemplate engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        return BeetlTemplate.wrap(this.engine.getTemplate((Object)resource));
    }

    private static GroupTemplate createEngine(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                return BeetlEngine.createGroupTemplate(new ClasspathResourceLoader(config.getPath(), config.getCharsetStr()));
            }
            case FILE: {
                return BeetlEngine.createGroupTemplate(new FileResourceLoader(config.getPath(), config.getCharsetStr()));
            }
            case WEB_ROOT: {
                return BeetlEngine.createGroupTemplate(new WebAppResourceLoader(config.getPath(), config.getCharsetStr()));
            }
            case STRING: {
                return BeetlEngine.createGroupTemplate(new StringTemplateResourceLoader());
            }
            case COMPOSITE: {
                return BeetlEngine.createGroupTemplate(new CompositeResourceLoader());
            }
        }
        return new GroupTemplate();
    }

    private static GroupTemplate createGroupTemplate(ResourceLoader<?> loader) {
        try {
            return BeetlEngine.createGroupTemplate(loader, Configuration.defaultConfiguration());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static GroupTemplate createGroupTemplate(ResourceLoader<?> loader, Configuration conf) {
        return new GroupTemplate(loader, conf);
    }
}

