/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.request.encrypt.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class JsonUtil {
    public static final ObjectMapper OBJECT_MAPPER = JsonUtil.createObjectMapper();

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        return objectMapper;
    }

    public static String object2Json(Object o) {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = null;
        try {
            gen = new JsonFactory().createGenerator((Writer)sw);
            OBJECT_MAPPER.writeValue(gen, o);
        }
        catch (IOException e) {
            throw new RuntimeException("\u4e0d\u80fd\u5e8f\u5217\u5316\u5bf9\u8c61\u4e3aJson", e);
        }
        finally {
            if (null != gen) {
                try {
                    gen.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("\u4e0d\u80fd\u5e8f\u5217\u5316\u5bf9\u8c61\u4e3aJson", e);
                }
            }
        }
        return sw.toString();
    }
}

