/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.request.encrypt.advice;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import top.redscorpion.request.encrypt.advice.DecryptHttpInputMessage;
import top.redscorpion.request.encrypt.annotations.Decrypt;
import top.redscorpion.request.encrypt.annotations.EncryptDecrypt;
import top.redscorpion.request.encrypt.config.EncryptProperties;

@ControllerAdvice
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private EncryptProperties ep;

    public DecryptRequestBodyAdvice(EncryptProperties ep) {
        this.ep = ep;
        Assert.notNull((Object)this.ep.getAesKey(), (String)"please config spring.encrypt.aes-key");
    }

    public boolean supports(MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return true;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return body;
    }

    public Object afterBodyRead(Object body, HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return body;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage im, MethodParameter mp, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        if (this.ep.isDebug()) {
            return im;
        }
        Method method = mp.getMethod();
        if (method.isAnnotationPresent(Decrypt.class) || method.isAnnotationPresent(EncryptDecrypt.class)) {
            try {
                return new DecryptHttpInputMessage(im, this.ep);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return im;
    }
}

