/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.webservice;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsXml;
import top.redscorpion.http.webservice.SoapClient;
import top.redscorpion.http.webservice.SoapProtocol;
import top.redscorpion.http.webservice.SoapRuntimeException;

public class SoapUtil {
    public static SoapClient createClient(String url) {
        return SoapClient.create(url);
    }

    public static SoapClient createClient(String url, SoapProtocol protocol) {
        return SoapClient.create(url, protocol);
    }

    public static SoapClient createClient(String url, SoapProtocol protocol, String namespaceUri) {
        return SoapClient.create(url, protocol, namespaceUri);
    }

    public static String toString(SOAPMessage message, boolean pretty) {
        return SoapUtil.toString(message, pretty, RsCharset.CHARSET_UTF_8);
    }

    public static String toString(SOAPMessage message, boolean pretty, Charset charset) {
        String messageToString;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)out);
        }
        catch (IOException | SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        try {
            messageToString = out.toString(charset.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RsException(e);
        }
        return pretty ? RsXml.format(messageToString) : messageToString;
    }
}

