/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.io.FastByteArrayOutputStream;
import top.redscorpion.core.io.FileUtil;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.io.StreamProgress;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsUrl;
import top.redscorpion.http.AbstractHttpBase;
import top.redscorpion.http.Header;
import top.redscorpion.http.HttpConfig;
import top.redscorpion.http.HttpConnection;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.HttpInputStream;
import top.redscorpion.http.HttpUtil;
import top.redscorpion.http.cookie.GlobalCookieManager;

public class HttpResponse
extends AbstractHttpBase<HttpResponse>
implements Closeable {
    protected HttpConfig config;
    protected HttpConnection httpConnection;
    protected InputStream in;
    private volatile boolean isAsync;
    protected int status;
    private final boolean ignoreBody;
    private Charset charsetFromResponse;

    protected HttpResponse(HttpConnection httpConnection, HttpConfig config, Charset charset, boolean isAsync, boolean isIgnoreBody) {
        this.httpConnection = httpConnection;
        this.config = config;
        this.charset = charset;
        this.isAsync = isAsync;
        this.ignoreBody = isIgnoreBody;
        this.initWithDisconnect();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status >= 200 && this.status < 300;
    }

    public HttpResponse sync() {
        return this.isAsync ? this.forceSync() : this;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public long contentLength() {
        boolean theCondition;
        long contentLength = Convert.toLong(this.header(Header.CONTENT_LENGTH), -1L);
        boolean bl = theCondition = contentLength > 0L && (this.isChunked() || RsString.isNotBlank(this.contentEncoding()));
        if (theCondition) {
            contentLength = -1L;
        }
        return contentLength;
    }

    public boolean isGzip() {
        String contentEncoding = this.contentEncoding();
        return "gzip".equalsIgnoreCase(contentEncoding);
    }

    public boolean isDeflate() {
        String contentEncoding = this.contentEncoding();
        return "deflate".equalsIgnoreCase(contentEncoding);
    }

    public boolean isChunked() {
        String transferEncoding = this.header(Header.TRANSFER_ENCODING);
        return "Chunked".equalsIgnoreCase(transferEncoding);
    }

    public String getCookieStr() {
        return this.header(Header.SET_COOKIE);
    }

    public List<HttpCookie> getCookies() {
        return GlobalCookieManager.getCookies(this.httpConnection);
    }

    public HttpCookie getCookie(String name) {
        List<HttpCookie> cookie = this.getCookies();
        if (null != cookie) {
            for (HttpCookie httpCookie : cookie) {
                if (!httpCookie.getName().equals(name)) continue;
                return httpCookie;
            }
        }
        return null;
    }

    public String getCookieValue(String name) {
        HttpCookie cookie = this.getCookie(name);
        return null == cookie ? null : cookie.getValue();
    }

    public InputStream bodyStream() {
        if (this.isAsync) {
            return this.in;
        }
        return new ByteArrayInputStream(this.bodyBytes);
    }

    @Override
    public byte[] bodyBytes() {
        this.sync();
        return this.bodyBytes;
    }

    public String body() throws HttpException {
        return HttpUtil.getString(this.bodyBytes(), this.charset, null == this.charsetFromResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeBody(OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        Assert.notNull(out, "[out] must be not null!", new Object[0]);
        long contentLength = this.contentLength();
        try {
            long l = HttpResponse.copyBody(this.bodyStream(), out, contentLength, streamProgress, this.config.ignoreEOFError);
            return l;
        }
        finally {
            IoUtil.close(this);
            if (isCloseOut) {
                IoUtil.close(out);
            }
        }
    }

    public long writeBody(File targetFileOrDir, StreamProgress streamProgress) {
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        return this.writeBody(FileUtil.getOutputStream(outFile), true, streamProgress);
    }

    public long writeBody(File targetFileOrDir, String tempFileSuffix, StreamProgress streamProgress) {
        long length;
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        tempFileSuffix = RsString.isBlank(tempFileSuffix) ? ".temp" : RsString.addPrefixIfNot(tempFileSuffix, ".");
        String fileName = outFile.getName();
        String tempFileName = fileName + tempFileSuffix;
        outFile = new File(outFile.getParentFile(), tempFileName);
        try {
            length = this.writeBody(outFile, streamProgress);
            FileUtil.rename(outFile, fileName, true);
        }
        catch (Throwable e) {
            FileUtil.del(outFile);
            throw new HttpException(e);
        }
        return length;
    }

    public File writeBodyForFile(File targetFileOrDir, StreamProgress streamProgress) {
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        this.writeBody(FileUtil.getOutputStream(outFile), true, streamProgress);
        return outFile;
    }

    public long writeBody(File targetFileOrDir) {
        return this.writeBody(targetFileOrDir, null);
    }

    public long writeBody(String targetFileOrDir) {
        return this.writeBody(FileUtil.file(targetFileOrDir));
    }

    @Override
    public void close() {
        IoUtil.close(this.in);
        this.in = null;
        this.httpConnection.disconnectQuietly();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Response Headers: ").append("\r\n");
        for (Map.Entry entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Response Body: ").append("\r\n");
        sb.append("    ").append(this.body()).append("\r\n");
        return sb.toString();
    }

    public File completeFileNameFromHeader(File targetFileOrDir) {
        if (!targetFileOrDir.isDirectory()) {
            return targetFileOrDir;
        }
        String fileName = this.getFileNameFromDisposition();
        if (RsString.isBlank(fileName)) {
            String path = this.httpConnection.getUrl().getPath();
            fileName = RsString.subSuf(path, path.lastIndexOf(47) + 1);
            fileName = RsString.isBlank(fileName) ? RsUrl.encodeQuery(path, this.charset) : RsUrl.decode(fileName, this.charset);
        }
        return FileUtil.file(targetFileOrDir, fileName);
    }

    private HttpResponse initWithDisconnect() throws HttpException {
        try {
            this.init();
        }
        catch (HttpException e) {
            this.httpConnection.disconnectQuietly();
            throw e;
        }
        return this;
    }

    private HttpResponse init() throws HttpException {
        Charset charset;
        block5: {
            try {
                this.status = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block5;
                throw new HttpException(e);
            }
        }
        try {
            this.headers = this.httpConnection.headers();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        GlobalCookieManager.store(this.httpConnection);
        this.charsetFromResponse = charset = this.httpConnection.getCharset();
        if (null != charset) {
            this.charset = charset;
        }
        this.in = new HttpInputStream(this);
        return this.isAsync ? this : this.forceSync();
    }

    private HttpResponse forceSync() {
        block7: {
            try {
                this.readBody(this.in);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    break block7;
                }
                throw new HttpException(e);
            }
            finally {
                if (this.isAsync) {
                    this.isAsync = false;
                }
                this.close();
            }
        }
        return this;
    }

    private void readBody(InputStream in) throws IORuntimeException {
        if (this.ignoreBody) {
            return;
        }
        long contentLength = this.contentLength();
        FastByteArrayOutputStream out = new FastByteArrayOutputStream((int)contentLength);
        HttpResponse.copyBody(in, out, contentLength, null, this.config.ignoreEOFError);
        this.bodyBytes = out.toByteArray();
    }

    private static long copyBody(InputStream in, OutputStream out, long contentLength, StreamProgress streamProgress, boolean isIgnoreEofError) {
        long copyLength;
        block3: {
            if (null == out) {
                throw new NullPointerException("[out] is null!");
            }
            copyLength = -1L;
            try {
                copyLength = IoUtil.copy(in, out, 8192, contentLength, streamProgress);
            }
            catch (IORuntimeException e) {
                boolean theCondition;
                boolean bl = theCondition = isIgnoreEofError && (e.getCause() instanceof EOFException || RsString.containsIgnoreCase(e.getMessage(), "Premature EOF"));
                if (theCondition) break block3;
                throw e;
            }
        }
        return copyLength;
    }

    private String getFileNameFromDisposition() {
        String fileName = null;
        String disposition = this.header(Header.CONTENT_DISPOSITION);
        if (RsString.isNotBlank(disposition) && RsString.isBlank(fileName = RsRegular.get("filename=\"(.*?)\"", (CharSequence)disposition, 1))) {
            fileName = RsString.subAfter((CharSequence)disposition, "filename=", true);
        }
        return fileName;
    }
}

