/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http;

import java.nio.charset.Charset;
import top.redscorpion.core.util.RsString;

public enum ContentType {
    FORM_URLENCODED("application/x-www-form-urlencoded"),
    MULTIPART("multipart/form-data"),
    JSON("application/json"),
    XML("application/xml"),
    TEXT_PLAIN("text/plain"),
    TEXT_XML("text/xml"),
    TEXT_HTML("text/html"),
    OCTET_STREAM("application/octet-stream");

    private final String value;

    private ContentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    public String toString(Charset charset) {
        return ContentType.build(this.value, charset);
    }

    public static boolean isDefault(String contentType) {
        return null == contentType || ContentType.isFormUrlEncode(contentType);
    }

    public static boolean isFormUrlEncode(String contentType) {
        return RsString.startWith(contentType, FORM_URLENCODED.toString(), true);
    }

    public static ContentType get(String body) {
        ContentType contentType = null;
        if (RsString.isNotBlank(body)) {
            char firstChar = body.charAt(0);
            switch (firstChar) {
                case '[': 
                case '{': {
                    contentType = JSON;
                    break;
                }
                case '<': {
                    contentType = XML;
                    break;
                }
            }
        }
        return contentType;
    }

    public static String build(String contentType, Charset charset) {
        return RsString.format("{};charset={}", contentType, charset.name());
    }

    public static String build(ContentType contentType, Charset charset) {
        return ContentType.build(contentType.getValue(), charset);
    }
}

