/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.servlet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import top.redscorpion.core.net.NetUtil;
import top.redscorpion.core.util.RsArray;

public class ServletUtil {
    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        for (Map.Entry<String, String[]> entry : ServletUtil.getParams(request).entrySet()) {
            params.put(entry.getKey(), RsArray.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    public static String getClientIp(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (RsArray.isNotEmpty(otherHeaderNames)) {
            headers = RsArray.addAll(headers, otherHeaderNames);
        }
        return ServletUtil.getClientIpByHeader(request, headers);
    }

    public static String getClientIpByHeader(HttpServletRequest request, String ... headerNames) {
        String ip0;
        String ip127;
        String ip = "";
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown(ip)) continue;
            ip = NetUtil.getMultistageReverseProxyIp(ip);
            break;
        }
        if (NetUtil.isUnknown(ip) && (ip127 = "127.0.0.1").equals(ip = request.getRemoteAddr())) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                ip = inet.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if ((ip0 = "0:0:0:0:0:0:0:1").equals(ip = NetUtil.getMultistageReverseProxyIp(ip))) {
            ip = "127.0.0.1";
        }
        return ip;
    }
}

