/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.net.UrlDecoder;
import top.redscorpion.core.net.UrlEncodeUtil;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsClassLoader;
import top.redscorpion.core.util.RsString;

public class RsUrl
extends UrlEncodeUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";

    public static URL url(String url) {
        return RsUrl.url(url, null);
    }

    public static URL url(String url, URLStreamHandler handler) {
        if (null == url) {
            return null;
        }
        if (url.startsWith(CLASSPATH_URL_PREFIX)) {
            url = url.substring(CLASSPATH_URL_PREFIX.length());
            return RsClassLoader.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException e) {
            try {
                return new File(url).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new RsException(e);
            }
        }
    }

    public static URL toUrlForHttp(String urlStr) {
        return RsUrl.toUrlForHttp(urlStr, null);
    }

    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = RsUrl.encodeBlank(urlStr);
        try {
            return new URL(null, urlStr, handler);
        }
        catch (MalformedURLException e) {
            throw new RsException(e);
        }
    }

    public static String encodeBlank(CharSequence urlStr) {
        if (urlStr == null) {
            return null;
        }
        int len = urlStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = urlStr.charAt(i);
            if (RsChar.isBlankChar(c)) {
                sb.append("%20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static URL getUrl(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RsException(e, "Error occured when get URL!", new Object[0]);
        }
    }

    public static String decode(String content, Charset charset) {
        return UrlDecoder.decode(content, charset);
    }

    public static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = RsUrl.toUri(url).getPath();
        }
        catch (RsException rsException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toUri(URL url) throws RsException {
        return RsUrl.toUri(url, false);
    }

    public static URI toUri(URL url, boolean isEncode) throws RsException {
        if (null == url) {
            return null;
        }
        return RsUrl.toUri(url.toString(), isEncode);
    }

    public static URI toUri(String location) throws RsException {
        return RsUrl.toUri(location, false);
    }

    public static URI toUri(String location, boolean isEncode) throws RsException {
        if (isEncode) {
            location = UrlEncodeUtil.encode(location);
        }
        try {
            return new URI(RsString.trim(location));
        }
        catch (URISyntaxException e) {
            throw new RsException(e);
        }
    }
}

