/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import top.redscorpion.core.lang.ParameterizedTypeImpl;
import top.redscorpion.core.lang.reflect.ActualTypeMapperPool;
import top.redscorpion.core.util.RsArray;

public class RsType {
    public static Class<?> getClass(Type type) {
        if (null != type) {
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                return (Class)((TypeVariable)type).getBounds()[0];
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return RsType.getClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        return field.getGenericType();
    }

    public static Class<?> getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Class<?> getFirstParamClass(Method method) {
        return RsType.getParamClass(method, 0);
    }

    public static Type getParamType(Method method, int index) {
        Type[] types = RsType.getParamTypes(method);
        if (null != types && types.length > index) {
            return types[index];
        }
        return null;
    }

    public static Class<?> getParamClass(Method method, int index) {
        Class<?>[] classes = RsType.getParamClasses(method);
        if (null != classes && classes.length > index) {
            return classes[index];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Type type) {
        return RsType.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = RsType.getTypeArguments(type);
        if (null != typeArguments && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType parameterizedType = RsType.toParameterizedType(type);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && RsArray.isNotEmpty(genericInterfaces = clazz.getGenericInterfaces())) {
                genericSuper = genericInterfaces[0];
            }
            result = RsType.toParameterizedType(genericSuper);
        }
        return result;
    }

    public static boolean isUnknown(Type type) {
        return null == type || type instanceof TypeVariable;
    }

    public static boolean hasTypeVariable(Type ... types) {
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }

    public static Type getActualType(Type type, Type typeVariable) {
        if (typeVariable instanceof ParameterizedType) {
            return RsType.getActualType(type, (ParameterizedType)typeVariable);
        }
        if (typeVariable instanceof TypeVariable) {
            return ActualTypeMapperPool.getActualType(type, (TypeVariable)typeVariable);
        }
        return typeVariable;
    }

    public static Type getActualType(Type type, ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (RsType.hasTypeVariable(actualTypeArguments) && RsArray.isNotEmpty(actualTypeArguments = RsType.getActualTypes(type, parameterizedType.getActualTypeArguments()))) {
            parameterizedType = new ParameterizedTypeImpl(actualTypeArguments, parameterizedType.getOwnerType(), parameterizedType.getRawType());
        }
        return parameterizedType;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        return ActualTypeMapperPool.getActualTypes(type, typeVariables);
    }
}

