/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import top.redscorpion.core.annotation.Alias;
import top.redscorpion.core.bean.NullWrapperBean;
import top.redscorpion.core.collection.UniqueKeySet;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.exceptions.InvocationTargetRuntimeException;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.reflect.MethodHandleUtil;
import top.redscorpion.core.map.WeakConcurrentMap;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsString;

public class RsReflect {
    private static final WeakConcurrentMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Field[]> FIELDS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Method[]> METHODS_CACHE = new WeakConcurrentMap();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = RsReflect.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!RsClass.isAllAssignableFrom(pts, parameterTypes)) continue;
            RsReflect.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, () -> RsReflect.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static String getFieldName(Field field) {
        if (null == field) {
            return null;
        }
        Alias alias = field.getAnnotation(Alias.class);
        if (null != alias) {
            return alias.value();
        }
        return field.getName();
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = RsReflect.getFields(beanClass);
        return RsArray.firstMatch(field -> name.equals(RsReflect.getFieldName(field)), fields);
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, () -> RsReflect.getFieldsDirectly(beanClass, true));
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : RsArray.append(allFields, declaredFields);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static Object getStaticFieldValue(Field field) throws RsException {
        return RsReflect.getFieldValue(null, field);
    }

    public static Object getFieldValue(Object obj, Field field) throws RsException {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        RsReflect.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RsException(e, "IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws RsException {
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        Field field = RsReflect.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        RsReflect.setFieldValue(obj, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws RsException {
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = RsClass.getDefaultValue(fieldType);
        }
        RsReflect.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RsException(e, "IllegalAccess for {}.{}", obj, field.getName());
        }
    }

    public static boolean isOuterClassField(Field field) {
        return "this$0".equals(field.getName());
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || RsString.isBlank(methodName)) {
            return null;
        }
        return RsReflect.getMethod(obj.getClass(), methodName, RsClass.getClasses(args));
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return RsReflect.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || RsString.isBlank(methodName)) {
            return null;
        }
        Method[] methods = RsReflect.getMethods(clazz);
        if (RsArray.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!RsString.equals(methodName, method.getName(), ignoreCase) || !RsClass.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || method.isBridge()) continue;
                return method;
            }
        }
        return null;
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return METHODS_CACHE.computeIfAbsent(beanClass, () -> RsReflect.getMethodsDirectly(beanClass, true, true));
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        Assert.notNull(beanClass);
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        UniqueKeySet<String, Method> result = new UniqueKeySet<String, Method>(true, RsReflect::getUniqueKey);
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result.addAllIfAbsent(Arrays.asList(searchType.getDeclaredMethods()));
            result.addAllIfAbsent(RsReflect.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && false == searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result.toArray(new Method[0]);
    }

    public static <T> T newInstance(String clazz) {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new RsException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws RsException {
        if (RsArray.isEmpty(params)) {
            Constructor<T> constructor = RsReflect.getConstructor(clazz, new Class[0]);
            if (null == constructor) {
                throw new RsException("No constructor for [{}]", clazz);
            }
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RsException(e, "Instance class [{}] error!", clazz);
            }
        }
        Class<?>[] paramTypes = RsClass.getClasses(params);
        Constructor<T> constructor = RsReflect.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new RsException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new RsException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        Assert.notNull(type);
        if (type.isPrimitive()) {
            return (T)RsClass.getPrimitiveDefaultValue(type);
        }
        if (type.isAssignableFrom(AbstractMap.class)) {
            type = HashMap.class;
        } else if (type.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (type.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        }
        try {
            return (T)RsReflect.newInstance(type, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<Object>[] constructors;
            if (type.isEnum()) {
                return (T)type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<Object> constructor : constructors = RsReflect.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                RsReflect.setAccessible(constructor);
                try {
                    return (T)constructor.newInstance(RsClass.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws RsException {
        return RsReflect.invoke(null, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws InvocationTargetRuntimeException, RsException {
        try {
            return RsReflect.invokeRaw(obj, method, args);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RsException(e);
        }
    }

    public static <T> T invokeRaw(Object obj, Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        RsReflect.setAccessible(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = RsClass.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (args[i] instanceof NullWrapperBean) {
                    actualArgs[i] = null;
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = Convert.convert(parameterTypes[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        if (method.isDefault()) {
            return MethodHandleUtil.invokeSpecial(obj, method, args);
        }
        return (T)method.invoke(RsClass.isStatic(method) ? null : obj, actualArgs);
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws RsException {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = RsReflect.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new RsException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return RsReflect.invoke(obj, method, args);
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    private static String getUniqueKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (RsModifier.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return result;
    }
}

