/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import top.redscorpion.core.util.RsString;

public class RsRandom {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR_LOWER = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String BASE_NUMBER_LOWER = "0123456789abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_NUMBER_UPPER = "0123456789abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_NUMBER_CHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        return RsRandom.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return RsRandom.createSecureRandom(seed);
    }

    public static int randomInt(int limit) {
        return RsRandom.getRandom().nextInt(limit);
    }

    public static long randomLong(long limit) {
        return RsRandom.getRandom().nextLong(limit);
    }

    public static String randomString(int length) {
        return RsRandom.randomString(BASE_NUMBER_CHAR, length);
    }

    public static String randomNumber(int length) {
        return RsRandom.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        if (RsString.isEmpty(baseString)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RsRandom.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }
}

