/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import top.redscorpion.core.collection.IterUtil;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.map.MapUtil;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsNumber;
import top.redscorpion.core.util.RsReflect;
import top.redscorpion.core.util.RsSerialize;
import top.redscorpion.core.util.RsString;

public class RsObject {
    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
            return RsNumber.equals((BigDecimal)obj1, (BigDecimal)obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static boolean notEqual(Object obj1, Object obj2) {
        return false == RsObject.equals(obj1, obj2);
    }

    public static boolean isNull(Object obj) {
        return null == obj || obj.equals(null);
    }

    public static boolean isNotNull(Object obj) {
        return null != obj && false == obj.equals(null);
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return RsString.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)obj);
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)obj);
        }
        if (RsArray.isArray(obj)) {
            return RsArray.isEmpty(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return false == RsObject.isEmpty(obj);
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return RsObject.isNull(object) ? defaultValue : object;
    }

    public static <T> T defaultIfNull(T source, Supplier<? extends T> defaultValueSupplier) {
        if (RsObject.isNull(source)) {
            return defaultValueSupplier.get();
        }
        return source;
    }

    public static <T> T clone(T obj) {
        T result = RsArray.clone(obj);
        if (null == result) {
            result = obj instanceof Cloneable ? RsReflect.invoke(obj, "clone", new Object[0]) : RsObject.cloneByStream(obj);
        }
        return result;
    }

    public static <T> T cloneByStream(T obj) {
        return RsSerialize.clone(obj);
    }

    public static <T> byte[] serialize(T obj) {
        return RsSerialize.serialize(obj);
    }

    public static <T> T deserialize(byte[] bytes) {
        return RsSerialize.deserialize(bytes);
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "null";
        }
        if (obj instanceof Map) {
            return obj.toString();
        }
        return Convert.toStr(obj);
    }
}

