/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text;

import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Predicate;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.Filter;
import top.redscorpion.core.text.NamingCase;
import top.redscorpion.core.text.StringFormatter;
import top.redscorpion.core.text.StringSplitter;
import top.redscorpion.core.text.finder.CharFinder;
import top.redscorpion.core.text.finder.StringFinder;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsCharset;

public class CharSequenceHandle {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (RsChar.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return false == CharSequenceHandle.isBlank(str);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (RsArray.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceHandle.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (RsArray.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceHandle.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return false == CharSequenceHandle.isEmpty(str);
    }

    public static String nullToEmpty(CharSequence str) {
        return CharSequenceHandle.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String emptyToDefault(CharSequence str, String defaultStr) {
        return CharSequenceHandle.isEmpty(str) ? defaultStr : str.toString();
    }

    public static String blankToDefault(CharSequence str, String defaultStr) {
        return CharSequenceHandle.isBlank(str) ? defaultStr : str.toString();
    }

    public static String trim(CharSequence str) {
        return null == str ? null : CharSequenceHandle.trim(str, 0);
    }

    public static String trimStart(CharSequence str) {
        return CharSequenceHandle.trim(str, -1);
    }

    public static String trimEnd(CharSequence str) {
        return CharSequenceHandle.trim(str, 1);
    }

    public static String trim(CharSequence str, int mode) {
        return CharSequenceHandle.trim(str, mode, RsChar::isBlankChar);
    }

    public static String trim(CharSequence str, int mode, Predicate<Character> predicate) {
        String result;
        if (str == null) {
            result = null;
        } else {
            int start;
            int length = str.length();
            int end = length;
            if (mode <= 0) {
                for (start = 0; start < end && predicate.test(Character.valueOf(str.charAt(start))); ++start) {
                }
            }
            if (mode >= 0) {
                while (start < end && predicate.test(Character.valueOf(str.charAt(end - 1)))) {
                    --end;
                }
            }
            result = start > 0 || end < length ? str.toString().substring(start, end) : str.toString();
        }
        return result;
    }

    public static boolean startWith(CharSequence str, char c) {
        if (CharSequenceHandle.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        return CharSequenceHandle.startWith(str, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str || null == prefix) {
            if (ignoreEquals) {
                return false;
            }
            return null == str && null == prefix;
        }
        boolean isStartWith = str.toString().regionMatches(ignoreCase, 0, prefix.toString(), 0, prefix.length());
        if (isStartWith) {
            return false == ignoreEquals || false == CharSequenceHandle.equals(str, prefix, ignoreCase);
        }
        return false;
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.startWith(str, prefix, false);
    }

    public static boolean endWith(CharSequence str, char c) {
        if (CharSequenceHandle.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        return CharSequenceHandle.endWith(str, suffix, ignoreCase, false);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str || null == suffix) {
            if (ignoreEquals) {
                return false;
            }
            return null == str && null == suffix;
        }
        int strOffset = str.length() - suffix.length();
        boolean isEndWith = str.toString().regionMatches(ignoreCase, strOffset, suffix.toString(), 0, suffix.length());
        if (isEndWith) {
            return false == ignoreEquals || false == CharSequenceHandle.equals(str, suffix, ignoreCase);
        }
        return false;
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return CharSequenceHandle.endWith(str, suffix, false);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        return CharSequenceHandle.endWithAny(str, false, suffixes);
    }

    public static boolean endWithAny(CharSequence str, boolean isIgnoreCase, CharSequence ... suffixes) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceHandle.endWith(str, suffix, isIgnoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return CharSequenceHandle.indexOf(str, searchChar) > -1;
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceHandle.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!CharSequenceHandle.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!RsArray.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        return CharSequenceHandle.getContainsStr(str, false, testStrs);
    }

    public static String getContainsStr(CharSequence str, boolean ignoreCase, CharSequence ... testStrs) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            boolean theCondition = ignoreCase ? CharSequenceHandle.containsIgnoreCase(str, checkStr) : str.toString().contains(checkStr);
            if (!theCondition) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return CharSequenceHandle.indexOf(str, testStr, true) > -1;
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceHandle.getContainsStr(str, true, testStrs);
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return CharSequenceHandle.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return CharSequenceHandle.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence text, char searchChar, int start, int end) {
        if (CharSequenceHandle.isEmpty(text)) {
            return -1;
        }
        return new CharFinder(searchChar).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOf(CharSequence text, CharSequence searchStr) {
        return CharSequenceHandle.indexOf(text, searchStr, 0);
    }

    public static int indexOf(CharSequence text, CharSequence searchStr, boolean ignoreCase) {
        return CharSequenceHandle.indexOf(text, searchStr, 0, ignoreCase);
    }

    public static int indexOf(CharSequence text, CharSequence searchStr, int from) {
        return CharSequenceHandle.indexOf(text, searchStr, from, false);
    }

    public static int indexOf(CharSequence text, CharSequence searchStr, int from, boolean ignoreCase) {
        if (CharSequenceHandle.isEmpty(text) || CharSequenceHandle.isEmpty(searchStr)) {
            if (CharSequenceHandle.equals(text, searchStr)) {
                return 0;
            }
            return -1;
        }
        return new StringFinder(searchStr, ignoreCase).setText(text).start(from);
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (null == str || RsArray.isEmpty((Object)chars)) {
            return CharSequenceHandle.str(str);
        }
        int len = str.length();
        if (0 == len) {
            return CharSequenceHandle.str(str);
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (RsArray.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.removePrefix(str, prefix, false);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(prefix)) {
            return CharSequenceHandle.str(str);
        }
        String str2 = str.toString();
        boolean theCondition = ignoreCase ? CharSequenceHandle.startWith(str, prefix, true) : str2.startsWith(prefix.toString());
        if (theCondition) {
            return CharSequenceHandle.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        return CharSequenceHandle.removeSuffix(str, suffix, false);
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(suffix)) {
            return CharSequenceHandle.str(str);
        }
        String str2 = str.toString();
        boolean theCondition = ignoreCase ? CharSequenceHandle.endWith(str, suffix, true) : str2.endsWith(suffix.toString());
        if (theCondition) {
            return CharSequenceHandle.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String cleanBlank(CharSequence str) {
        return CharSequenceHandle.filter(str, c -> false == RsChar.isBlankChar(c.charValue()));
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.prependIfMissing(str, prefix, prefix);
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        return CharSequenceHandle.appendIfMissing(str, suffix, suffix);
    }

    public static List<String> split(CharSequence str, char separator) {
        return CharSequenceHandle.split(str, separator, 0);
    }

    public static String[] splitToArray(CharSequence str, char separator) {
        return CharSequenceHandle.splitToArray(str, separator, 0);
    }

    public static String[] splitToArray(CharSequence text, char separator, int limit) {
        Assert.notNull(text, "Text must be not null!", new Object[0]);
        return StringSplitter.splitToArray(text.toString(), separator, limit, false, false);
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        return CharSequenceHandle.split(str, separator, limit, false, false);
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return CharSequenceHandle.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, char separator, int limit) {
        return CharSequenceHandle.split(str, separator, limit, true, true);
    }

    public static List<String> split(CharSequence str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return CharSequenceHandle.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitter.split(str, separator, limit, isTrim, ignoreEmpty);
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (CharSequenceHandle.isEmpty(str)) {
            return CharSequenceHandle.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String subPre(CharSequence string, int toIndexExclude) {
        return CharSequenceHandle.sub(string, 0, toIndexExclude);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (CharSequenceHandle.isEmpty(string)) {
            return null;
        }
        return CharSequenceHandle.sub(string, fromIndex, string.length());
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return EMPTY;
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : EMPTY;
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : EMPTY;
        }
        if (separator == null) {
            return EMPTY;
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : EMPTY;
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return EMPTY;
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return CharSequenceHandle.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static String repeatAndJoin(CharSequence str, int count, CharSequence delimiter) {
        if (count <= 0) {
            return EMPTY;
        }
        StringBuilder builder = new StringBuilder(str.length() * count);
        builder.append(str);
        boolean isAppendDelimiter = CharSequenceHandle.isNotEmpty(delimiter);
        while (true) {
            int n = --count;
            --count;
            if (n <= 0) break;
            if (isAppendDelimiter) {
                builder.append(delimiter);
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return CharSequenceHandle.equals(str1, str2, false);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        return CharSequenceHandle.equalsAny(str1, false, strs);
    }

    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... strs) {
        if (RsArray.isEmpty(strs)) {
            return false;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceHandle.equals(str1, str, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return NULL;
        }
        if (RsArray.isEmpty(params) || CharSequenceHandle.isBlank(template)) {
            return template.toString();
        }
        return StringFormatter.format(template.toString(), params);
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return CharSequenceHandle.bytes(str, RsCharset.CHARSET_UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return CharSequenceHandle.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return CharSequenceHandle.bytes(str, CharSequenceHandle.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (CharSequenceHandle.isEmpty(str)) {
            return CharSequenceHandle.str(str);
        }
        if (str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix) {
            return CharSequenceHandle.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharSequenceHandle.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceHandle.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        if (str == null || CharSequenceHandle.isEmpty(suffix) || CharSequenceHandle.endWith(str, suffix, ignoreCase)) {
            return CharSequenceHandle.str(str);
        }
        if (RsArray.isNotEmpty(testSuffixes)) {
            for (CharSequence testSuffix : testSuffixes) {
                if (!CharSequenceHandle.endWith(str, testSuffix, ignoreCase)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceHandle.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || CharSequenceHandle.isEmpty(prefix) || CharSequenceHandle.startWith(str, prefix, ignoreCase)) {
            return CharSequenceHandle.str(str);
        }
        if (prefixes != null && prefixes.length > 0) {
            for (CharSequence s : prefixes) {
                if (!CharSequenceHandle.startWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return prefix.toString().concat(str.toString());
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return CharSequenceHandle.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        return CharSequenceHandle.replace(str, 0, searchStr, replacement, ignoreCase);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        int index;
        int searchStrLength;
        int strLength;
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(searchStr)) {
            return CharSequenceHandle.str(str);
        }
        if (null == replacement) {
            replacement = EMPTY;
        }
        if ((strLength = str.length()) < (searchStrLength = searchStr.length())) {
            return CharSequenceHandle.str(str);
        }
        if (fromIndex > strLength) {
            return CharSequenceHandle.str(str);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StringBuilder result = new StringBuilder(strLength - searchStrLength + replacement.length());
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        while ((index = CharSequenceHandle.indexOf(str, searchStr, preIndex, ignoreCase)) > -1) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (CharSequenceHandle.isEmpty(str)) {
            return CharSequenceHandle.str(str);
        }
        String originalStr = CharSequenceHandle.str(str);
        int[] strCodePoints = originalStr.codePoints().toArray();
        int strLength = strCodePoints.length;
        if (startInclude > strLength) {
            return originalStr;
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < strLength; ++i) {
            if (i >= startInclude && i < endExclude) {
                stringBuilder.append(replacedChar);
                continue;
            }
            stringBuilder.append(new String(strCodePoints, i, 1));
        }
        return stringBuilder.toString();
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + CharSequenceHandle.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String lowerFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            return Character.toLowerCase(firstChar) + CharSequenceHandle.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String filter(CharSequence str, Filter<Character> filter) {
        if (str == null || filter == null) {
            return CharSequenceHandle.str(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!filter.accept(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toUnderlineCase(CharSequence str) {
        return NamingCase.toUnderlineCase(str);
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name);
    }
}

