/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.url;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import top.redscorpion.core.codec.PercentCodec;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.collection.IterUtil;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.map.MapUtil;
import top.redscorpion.core.map.TableMap;
import top.redscorpion.core.net.FormUrlencoded;
import top.redscorpion.core.net.RFC3986;
import top.redscorpion.core.net.UrlDecoder;
import top.redscorpion.core.util.RsString;

public class UrlQuery {
    private final TableMap<CharSequence, CharSequence> query;
    private final boolean isFormUrlEncoded;

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap, boolean isFormUrlEncoded) {
        return new UrlQuery(queryMap, isFormUrlEncoded);
    }

    public static UrlQuery of(String queryStr, Charset charset) {
        return UrlQuery.of(queryStr, charset, true);
    }

    public static UrlQuery of(String queryStr, Charset charset, boolean autoRemovePath) {
        return UrlQuery.of(queryStr, charset, autoRemovePath, false);
    }

    public static UrlQuery of(String queryStr, Charset charset, boolean autoRemovePath, boolean isFormUrlEncoded) {
        return new UrlQuery(isFormUrlEncoded).parse(queryStr, charset, autoRemovePath);
    }

    public UrlQuery() {
        this(null);
    }

    public UrlQuery(boolean isFormUrlEncoded) {
        this(null, isFormUrlEncoded);
    }

    public UrlQuery(Map<? extends CharSequence, ?> queryMap) {
        this(queryMap, false);
    }

    public UrlQuery(Map<? extends CharSequence, ?> queryMap, boolean isFormUrlEncoded) {
        if (MapUtil.isNotEmpty(queryMap)) {
            this.query = new TableMap(queryMap.size());
            this.addAll(queryMap);
        } else {
            this.query = new TableMap(16);
        }
        this.isFormUrlEncoded = isFormUrlEncoded;
    }

    public UrlQuery add(CharSequence key, Object value) {
        this.query.put(key, UrlQuery.toStr(value));
        return this;
    }

    public UrlQuery addAll(Map<? extends CharSequence, ?> queryMap) {
        if (MapUtil.isNotEmpty(queryMap)) {
            queryMap.forEach(this::add);
        }
        return this;
    }

    public UrlQuery parse(String queryStr, Charset charset) {
        return this.parse(queryStr, charset, true);
    }

    public UrlQuery parse(String queryStr, Charset charset, boolean autoRemovePath) {
        int pathEndPos;
        if (RsString.isBlank(queryStr)) {
            return this;
        }
        if (autoRemovePath && (pathEndPos = queryStr.indexOf(63)) > -1 && RsString.isBlank(queryStr = RsString.subSuf(queryStr, pathEndPos + 1))) {
            return this;
        }
        return this.doParse(queryStr, charset);
    }

    public Map<CharSequence, CharSequence> getQueryMap() {
        return MapUtil.unmodifiable(this.query);
    }

    public String build(Charset charset) {
        return this.build(charset, true);
    }

    public String build(Charset charset, boolean encodePercent) {
        if (this.isFormUrlEncoded) {
            return this.build(FormUrlencoded.ALL, FormUrlencoded.ALL, charset, encodePercent);
        }
        return this.build(RFC3986.QUERY_PARAM_NAME, RFC3986.QUERY_PARAM_VALUE, charset, encodePercent);
    }

    public String build(PercentCodec keyCoder, PercentCodec valueCoder, Charset charset) {
        return this.build(keyCoder, valueCoder, charset, true);
    }

    public String build(PercentCodec keyCoder, PercentCodec valueCoder, Charset charset, boolean encodePercent) {
        char[] cArray;
        if (MapUtil.isEmpty(this.query)) {
            return "";
        }
        if (encodePercent) {
            cArray = null;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 37;
        }
        char[] safeChars = cArray;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CharSequence, CharSequence> entry : this.query) {
            CharSequence name = entry.getKey();
            if (null == name) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(keyCoder.encode(name, charset, safeChars));
            CharSequence value = entry.getValue();
            if (null == value) continue;
            sb.append("=").append(valueCoder.encode(value, charset, safeChars));
        }
        return sb.toString();
    }

    private UrlQuery doParse(String queryStr, Charset charset) {
        int i;
        int len = queryStr.length();
        String name = null;
        int pos = 0;
        block4: for (i = 0; i < len; ++i) {
            char c = queryStr.charAt(i);
            switch (c) {
                case '=': {
                    if (null != name) continue block4;
                    name = queryStr.substring(pos, i);
                    pos = i + 1;
                    continue block4;
                }
                case '&': {
                    this.addParam(name, queryStr.substring(pos, i), charset);
                    name = null;
                    if (i + 4 < len && "amp;".equals(queryStr.substring(i + 1, i + 5))) {
                        i += 4;
                    }
                    pos = i + 1;
                }
            }
        }
        this.addParam(name, queryStr.substring(pos, i), charset);
        return this;
    }

    private static String toStr(Object value) {
        String result = value instanceof Iterable ? CollUtil.join((Iterable)value, ",") : (value instanceof Iterator ? IterUtil.join((Iterator)value, ",") : Convert.toStr(value));
        return result;
    }

    private void addParam(String key, String value, Charset charset) {
        if (null != key) {
            String actualKey = UrlDecoder.decode(key, charset, this.isFormUrlEncoded);
            this.query.put(actualKey, RsString.nullToEmpty(UrlDecoder.decode(value, charset, this.isFormUrlEncoded)));
        } else if (null != value) {
            this.query.put(UrlDecoder.decode(value, charset, this.isFormUrlEncoded), null);
        }
    }
}

