/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsString;

public class UrlDecoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte ESCAPE_CHAR = 37;

    public static String decodeForPath(String str, Charset charset) {
        return UrlDecoder.decode(str, charset, false);
    }

    public static String decode(String str, Charset charset) {
        return UrlDecoder.decode(str, charset, true);
    }

    public static String decode(String str, Charset charset, boolean isPlusToSpace) {
        if (null == charset) {
            return str;
        }
        return RsString.str(UrlDecoder.decode(RsString.bytes((CharSequence)str, charset), isPlusToSpace), charset);
    }

    public static byte[] decode(byte[] bytes) {
        return UrlDecoder.decode(bytes, true);
    }

    public static byte[] decode(byte[] bytes, boolean isPlusToSpace) {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b == 43) {
                buffer.write(isPlusToSpace ? 32 : b);
                continue;
            }
            if (b == 37) {
                int l;
                int u;
                if (i + 1 < bytes.length && (u = RsChar.digit16(bytes[i + 1])) >= 0 && i + 2 < bytes.length && (l = RsChar.digit16(bytes[i + 2])) >= 0) {
                    buffer.write((char)((u << 4) + l));
                    i += 2;
                    continue;
                }
                buffer.write(b);
                continue;
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }
}

