/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.map;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.map.MapWrapper;
import top.redscorpion.core.util.RsReflect;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        return MapUtil.newHashMap(16, isLinked);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (null == mapType || mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        try {
            return (Map)RsReflect.newInstance(mapType, new Object[0]);
        }
        catch (RsException e) {
            return new HashMap();
        }
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        Map result = MapUtil.createMap(map.getClass());
        map.forEach((key, value) -> result.put(value, key));
        return result;
    }

    public static <K, V> MapWrapper<K, V> wrap(Map<K, V> map) {
        return new MapWrapper<K, V>(map);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    public static String getStr(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, String.class);
    }

    public static Integer getInt(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Integer.class);
    }

    public static <T> T get(Map<?, ?> map, Object key, Class<T> type) {
        return MapUtil.get(map, key, type, null);
    }

    public static <T> T get(Map<?, ?> map, Object key, Class<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convert(type, map.get(key), defaultValue);
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return MapUtil.entry(key, value, true);
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value, boolean isImmutable) {
        return isImmutable ? new AbstractMap.SimpleImmutableEntry<K, V>(key, value) : new AbstractMap.SimpleEntry<K, V>(key, value);
    }
}

