/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.reflect.LookupFactory;

public class MethodHandleUtil {
    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        return LookupFactory.lookup(callerClass);
    }

    public static <T> T invokeSpecial(Object obj, Method method, Object ... args) {
        return MethodHandleUtil.invoke(true, obj, method, args);
    }

    public static <T> T invoke(boolean isSpecial, Object obj, Method method, Object ... args) {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandles.Lookup lookup = MethodHandleUtil.lookup(declaringClass);
        try {
            MethodHandle handle;
            MethodHandle methodHandle = handle = isSpecial ? lookup.unreflectSpecial(method, declaringClass) : lookup.unreflect(method);
            if (null != obj) {
                handle = handle.bindTo(obj);
            }
            return (T)handle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new RsException(e);
        }
    }
}

