/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsString;

public class CharSequenceResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CharSequence data;
    private final CharSequence name;
    private final Charset charset;

    public CharSequenceResource(CharSequence data) {
        this(data, null);
    }

    public CharSequenceResource(CharSequence data, String name) {
        this(data, name, RsCharset.CHARSET_UTF_8);
    }

    public CharSequenceResource(CharSequence data, CharSequence name, Charset charset) {
        this.data = data;
        this.name = name;
        this.charset = charset;
    }

    @Override
    public String getName() {
        return RsString.str(this.name);
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoUtil.getReader(new StringReader(this.data.toString()));
    }

    @Override
    public String readStr(Charset charset) throws IORuntimeException {
        return this.data.toString();
    }

    @Override
    public byte[] readBytes() throws IORuntimeException {
        return this.data.toString().getBytes(this.charset);
    }
}

