/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.file.visitor.DelVisitor;
import top.redscorpion.core.io.file.visitor.MoveVisitor;
import top.redscorpion.core.lang.Assert;

public class PathUtil {
    public static boolean del(Path path) throws IORuntimeException {
        if (Files.notExists(path, new LinkOption[0])) {
            return true;
        }
        try {
            if (PathUtil.isDirectory(path)) {
                Files.walkFileTree(path, DelVisitor.INSTANCE);
            } else {
                PathUtil.delFile(path);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return true;
    }

    public static boolean isDirectory(Path path) {
        return PathUtil.isDirectory(path, false);
    }

    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isDirectory(path, options);
    }

    public static Path rename(Path path, String newName, boolean isOverride) {
        return PathUtil.move(path, path.resolveSibling(newName), isOverride);
    }

    public static Path move(Path src, Path target, boolean isOverride) {
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (PathUtil.isDirectory(target)) {
            target = target.resolve(src.getFileName());
        }
        return PathUtil.moveContent(src, target, isOverride);
    }

    public static Path moveContent(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        PathUtil.mkParentDirs(target);
        try {
            return Files.move(src, target, options);
        }
        catch (IOException e) {
            if (e instanceof FileAlreadyExistsException) {
                throw new IORuntimeException(e);
            }
            try {
                Files.walkFileTree(src, new MoveVisitor(src, target, options));
                PathUtil.del(src);
            }
            catch (IOException e2) {
                throw new IORuntimeException(e2);
            }
            return target;
        }
    }

    public static boolean equals(Path file1, Path file2) throws IORuntimeException {
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean exists(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.exists(path, options);
    }

    public static boolean isSub(Path parent, Path sub) {
        return PathUtil.toAbsNormal(sub).startsWith(PathUtil.toAbsNormal(parent));
    }

    public static Path toAbsNormal(Path path) {
        Assert.notNull(path);
        return path.toAbsolutePath().normalize();
    }

    public static String getMimeType(Path file) {
        try {
            return Files.probeContentType(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Path mkdir(Path dir) {
        if (null != dir && !PathUtil.exists(dir, false)) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return dir;
    }

    public static Path mkParentDirs(Path path) {
        return PathUtil.mkdir(path.getParent());
    }

    protected static void delFile(Path path) throws IOException {
        block2: {
            try {
                Files.delete(path);
            }
            catch (AccessDeniedException e) {
                if (path.toFile().delete()) break block2;
                throw e;
            }
        }
    }
}

