/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import top.redscorpion.core.io.FileUtil;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.io.file.FileWrapper;
import top.redscorpion.core.lang.Assert;

public class FileWriter
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileWriter create(File file, Charset charset) {
        return new FileWriter(file, charset);
    }

    public static FileWriter create(File file) {
        return new FileWriter(file);
    }

    public FileWriter(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileWriter(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public File write(String content, boolean isAppend) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = this.getWriter(isAppend);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(writer);
        }
        return this.file;
    }

    public File append(String content) throws IORuntimeException {
        return this.write(content, true);
    }

    public File write(byte[] data, int off, int len, boolean isAppend) throws IORuntimeException {
        try (FileOutputStream out = new FileOutputStream(FileUtil.touch(this.file), isAppend);){
            out.write(data, off, len);
            out.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this.file;
    }

    public BufferedWriter getWriter(boolean isAppend) throws IORuntimeException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtil.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    private void checkFile() throws IORuntimeException {
        Assert.notNull(this.file, "File to write content is null !", new Object[0]);
        if (this.file.exists() && !this.file.isFile()) {
            throw new IORuntimeException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }
}

