/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import java.io.Serializable;
import java.util.Date;
import top.redscorpion.core.date.DateUnit;
import top.redscorpion.core.lang.Assert;

public class DateBetween
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date begin;
    private final Date end;

    public DateBetween(Date begin, Date end, boolean isAbs) {
        Assert.notNull(begin, "Begin date is null !", new Object[0]);
        Assert.notNull(end, "End date is null !", new Object[0]);
        if (isAbs && begin.after(end)) {
            this.begin = end;
            this.end = begin;
        } else {
            this.begin = begin;
            this.end = end;
        }
    }

    public long between(DateUnit unit) {
        long diff = this.end.getTime() - this.begin.getTime();
        return diff / unit.getMillis();
    }
}

