/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.ConverterRegistry;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class ReferenceConverter
extends AbstractConverter<Reference> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Reference> targetType;

    public ReferenceConverter(Class<? extends Reference> targetType) {
        this.targetType = targetType;
    }

    @Override
    protected Reference<?> convertInternal(Object value) {
        Object targetValue = null;
        Type paramType = RsType.getTypeArgument(this.targetType);
        if (!RsType.isUnknown(paramType)) {
            targetValue = ConverterRegistry.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (this.targetType == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (this.targetType == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(RsString.format("Unsupport Reference type: {}", this.targetType.getName()));
    }
}

