/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.date.DateUtil;
import top.redscorpion.core.util.RsBoolean;
import top.redscorpion.core.util.RsByte;
import top.redscorpion.core.util.RsNumber;
import top.redscorpion.core.util.RsString;

public class NumberConverter
extends AbstractConverter<Number> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class<? extends Number> clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    @Override
    public Class<Number> getTargetType() {
        return this.targetType;
    }

    @Override
    protected Number convertInternal(Object value) {
        return NumberConverter.convert(value, this.targetType, this::convertToStr);
    }

    @Override
    protected String convertToStr(Object value) {
        char c;
        String result = RsString.trim(super.convertToStr(value));
        if (null != result && result.length() > 1 && ((c = Character.toUpperCase(result.charAt(result.length() - 1))) == 'D' || c == 'L' || c == 'F')) {
            return RsString.subPre(result, -1);
        }
        return result;
    }

    protected static Number convert(Object value, Class<? extends Number> targetType, Function<Object, String> toStrFunc) {
        if (value instanceof Enum) {
            return NumberConverter.convert(((Enum)value).ordinal(), targetType, toStrFunc);
        }
        if (value instanceof byte[]) {
            return RsByte.bytesToNumber((byte[])value, targetType, RsByte.DEFAULT_ORDER);
        }
        if (Byte.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof Boolean) {
                return RsBoolean.toByteObj((Boolean)value);
            }
            String valueStr = toStrFunc.apply(value);
            try {
                return RsString.isBlank(valueStr) ? null : Byte.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return RsNumber.parseNumber(valueStr).byteValue();
            }
        }
        if (Short.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return RsBoolean.toShortObj((Boolean)value);
            }
            String valueStr = toStrFunc.apply(value);
            try {
                return RsString.isBlank(valueStr) ? null : Short.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return RsNumber.parseNumber(valueStr).shortValue();
            }
        }
        if (Integer.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return RsBoolean.toInteger((Boolean)value);
            }
            if (value instanceof Date) {
                return (int)((Date)value).getTime();
            }
            if (value instanceof Calendar) {
                return (int)((Calendar)value).getTimeInMillis();
            }
            if (value instanceof TemporalAccessor) {
                return (int)DateUtil.toInstant((TemporalAccessor)value).toEpochMilli();
            }
            String valueStr = toStrFunc.apply(value);
            return RsString.isBlank(valueStr) ? null : Integer.valueOf(RsNumber.parseInt(valueStr));
        }
        if (AtomicInteger.class == targetType) {
            Number number = NumberConverter.convert(value, Integer.class, toStrFunc);
            if (null != number) {
                return new AtomicInteger(number.intValue());
            }
        } else {
            if (Long.class == targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof Boolean) {
                    return RsBoolean.toLongObj((Boolean)value);
                }
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                if (value instanceof Calendar) {
                    return ((Calendar)value).getTimeInMillis();
                }
                if (value instanceof TemporalAccessor) {
                    return DateUtil.toInstant((TemporalAccessor)value).toEpochMilli();
                }
                String valueStr = toStrFunc.apply(value);
                return RsString.isBlank(valueStr) ? null : Long.valueOf(RsNumber.parseLong(valueStr));
            }
            if (AtomicLong.class == targetType) {
                Number number = NumberConverter.convert(value, Long.class, toStrFunc);
                if (null != number) {
                    return new AtomicLong(number.longValue());
                }
            } else if (LongAdder.class == targetType) {
                Number number = NumberConverter.convert(value, Long.class, toStrFunc);
                if (null != number) {
                    LongAdder longValue = new LongAdder();
                    longValue.add(number.longValue());
                    return longValue;
                }
            } else {
                if (Float.class == targetType) {
                    if (value instanceof Number) {
                        return Float.valueOf(((Number)value).floatValue());
                    }
                    if (value instanceof Boolean) {
                        return RsBoolean.toFloatObj((Boolean)value);
                    }
                    String valueStr = toStrFunc.apply(value);
                    return RsString.isBlank(valueStr) ? null : Float.valueOf(RsNumber.parseFloat(valueStr));
                }
                if (Double.class == targetType) {
                    if (value instanceof Number) {
                        return RsNumber.toDouble((Number)value);
                    }
                    if (value instanceof Boolean) {
                        return RsBoolean.toDoubleObj((Boolean)value);
                    }
                    String valueStr = toStrFunc.apply(value);
                    return RsString.isBlank(valueStr) ? null : Double.valueOf(RsNumber.parseDouble(valueStr));
                }
                if (DoubleAdder.class == targetType) {
                    Number number = NumberConverter.convert(value, Double.class, toStrFunc);
                    if (null != number) {
                        DoubleAdder doubleAdder = new DoubleAdder();
                        doubleAdder.add(number.doubleValue());
                        return doubleAdder;
                    }
                } else {
                    if (BigDecimal.class == targetType) {
                        return NumberConverter.toBigDecimal(value, toStrFunc);
                    }
                    if (BigInteger.class == targetType) {
                        return NumberConverter.toBigInteger(value, toStrFunc);
                    }
                    if (Number.class == targetType) {
                        if (value instanceof Number) {
                            return (Number)value;
                        }
                        if (value instanceof Boolean) {
                            return RsBoolean.toInteger((Boolean)value);
                        }
                        String valueStr = toStrFunc.apply(value);
                        return RsString.isBlank(valueStr) ? (Number)null : (Number)RsNumber.parseNumber(valueStr);
                    }
                }
            }
        }
        throw new UnsupportedOperationException(RsString.format("Unsupport Number type: {}", targetType.getName()));
    }

    private static BigDecimal toBigDecimal(Object value, Function<Object, String> toStrFunc) {
        if (value instanceof Number) {
            return RsNumber.toBigDecimal((Number)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return RsNumber.toBigDecimal(toStrFunc.apply(value));
    }

    private static BigInteger toBigInteger(Object value, Function<Object, String> toStrFunc) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        return RsNumber.toBigInteger(toStrFunc.apply(value));
    }
}

