/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import top.redscorpion.core.bean.BeanUtil;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.ConverterRegistry;
import top.redscorpion.core.map.MapUtil;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class MapConverter
extends AbstractConverter<Map<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public MapConverter(Type mapType) {
        this(mapType, RsType.getTypeArgument(mapType, 0), RsType.getTypeArgument(mapType, 1));
    }

    public MapConverter(Type mapType, Type keyType, Type valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map<?, ?> convertInternal(Object value) {
        Map<Object, Object> map;
        if (value instanceof Map) {
            Type[] typeArguments;
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(this.mapType) && null != (typeArguments = RsType.getTypeArguments(valueClass)) && 2 == typeArguments.length && Objects.equals(this.keyType, typeArguments[0]) && Objects.equals(this.valueType, typeArguments[1])) {
                return (Map)value;
            }
            map = MapUtil.createMap(RsType.getClass(this.mapType));
            this.convertMapToMap((Map)value, map);
        } else if (BeanUtil.isBean(value.getClass())) {
            map = BeanUtil.beanToMap(value);
            map = this.convertInternal(map);
        } else {
            throw new UnsupportedOperationException(RsString.format("Unsupport toMap value type: {}", value.getClass().getName()));
        }
        return map;
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<Object, Object> targetMap) {
        ConverterRegistry convert = ConverterRegistry.getInstance();
        srcMap.forEach((key, value) -> {
            key = RsType.isUnknown(this.keyType) ? key : convert.convert(this.keyType, key);
            value = RsType.isUnknown(this.valueType) ? value : convert.convert(this.valueType, value);
            targetMap.put(key, value);
        });
    }

    @Override
    public Class<Map<?, ?>> getTargetType() {
        return RsType.getClass(this.mapType);
    }
}

