/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.BeanUtil;
import top.redscorpion.core.bean.copier.BeanCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.bean.copier.ValueProvider;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.map.MapProxy;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsReflect;
import top.redscorpion.core.util.RsType;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1L;
    private final Type beanType;
    private final Class<T> beanClass;
    private final CopyOptions copyOptions;

    public BeanConverter(Type beanType) {
        this(beanType, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Class<T> beanClass) {
        this(beanClass, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Type beanType, CopyOptions copyOptions) {
        this.beanType = beanType;
        this.beanClass = RsType.getClass(beanType);
        this.copyOptions = copyOptions;
    }

    @Override
    protected T convertInternal(Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtil.isBean(value.getClass())) {
            if (value instanceof Map && this.beanClass.isInterface()) {
                return MapProxy.create((Map)value).toProxyBean(this.beanClass);
            }
            return BeanCopier.create(value, RsReflect.newInstanceIfPossible(this.beanClass), this.beanType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return RsObject.deserialize((byte[])value);
        }
        throw new ConvertException("Unsupported source type: {}", value.getClass());
    }

    @Override
    public Class<T> getTargetType() {
        return this.beanClass;
    }
}

