/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.ConverterRegistry;
import top.redscorpion.core.convert.impl.EnumConverter;
import top.redscorpion.core.convert.impl.MapConverter;
import top.redscorpion.core.lang.AbstractTypeReference;

public class Convert {
    public static String toStr(Object value, String defaultValue) {
        return Convert.convertQuietly(String.class, value, defaultValue);
    }

    public static String toStr(Object value) {
        return Convert.toStr(value, null);
    }

    public static Character toChar(Object value, Character defaultValue) {
        return Convert.convertQuietly(Character.class, value, defaultValue);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        return Convert.convertQuietly(Byte.class, value, defaultValue);
    }

    public static Short toShort(Object value, Short defaultValue) {
        return Convert.convertQuietly(Short.class, value, defaultValue);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        return Convert.convertQuietly(Integer.class, value, defaultValue);
    }

    public static Long toLong(Object value, Long defaultValue) {
        return Convert.convertQuietly(Long.class, value, defaultValue);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        return Convert.convertQuietly(Double.class, value, defaultValue);
    }

    public static Float toFloat(Object value, Float defaultValue) {
        return Convert.convertQuietly(Float.class, value, defaultValue);
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        return Convert.convertQuietly(Boolean.class, value, defaultValue);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        return Convert.convertQuietly(BigInteger.class, value, defaultValue);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        return Convert.convertQuietly(BigDecimal.class, value, defaultValue);
    }

    public static Date toDate(Object value, Date defaultValue) {
        return Convert.convertQuietly(Date.class, value, defaultValue);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        return new EnumConverter(clazz).convertQuietly(value, defaultValue);
    }

    public static <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType, Object value) {
        if (value instanceof Map) {
            return Convert.toMap(value.getClass(), keyType, valueType, value);
        }
        return Convert.toMap(HashMap.class, keyType, valueType, value);
    }

    public static <K, V> Map<K, V> toMap(Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType, Object value) {
        return new MapConverter(mapType, keyType, valueType).convert(value, null);
    }

    public static <T> T convert(Class<T> type, Object value) throws ConvertException {
        return Convert.convert(type, value);
    }

    public static <T> T convert(AbstractTypeReference<T> reference, Object value) throws ConvertException {
        return Convert.convert(reference.getType(), value, null);
    }

    public static <T> T convert(Type type, Object value) throws ConvertException {
        return Convert.convert(type, value, null);
    }

    public static <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return Convert.convertWithCheck(type, value, defaultValue, false);
    }

    public static <T> T convertQuietly(Type type, Object value, T defaultValue) {
        return Convert.convertWithCheck(type, value, defaultValue, true);
    }

    public static <T> T convertWithCheck(Type type, Object value, T defaultValue, boolean quietly) {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        try {
            return registry.convert(type, value, defaultValue);
        }
        catch (Exception e) {
            if (quietly) {
                return defaultValue;
            }
            throw e;
        }
    }
}

