/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import top.redscorpion.core.map.MapBuilder;

public class UniqueKeySet<K, V>
extends AbstractSet<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K, V> map;
    private final Function<V, K> uniqueGenerator;

    public UniqueKeySet(boolean isLinked, Function<V, K> uniqueGenerator) {
        this(MapBuilder.create(isLinked), uniqueGenerator);
    }

    public UniqueKeySet(MapBuilder<K, V> builder, Function<V, K> uniqueGenerator) {
        this.map = builder.build();
        this.uniqueGenerator = uniqueGenerator;
    }

    @Override
    public Iterator<V> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(this.uniqueGenerator.apply(o));
    }

    @Override
    public boolean add(V v) {
        return null == this.map.put(this.uniqueGenerator.apply(v), v);
    }

    public boolean addIfAbsent(V v) {
        return null == this.map.putIfAbsent(this.uniqueGenerator.apply(v), v);
    }

    public boolean addAllIfAbsent(Collection<? extends V> c) {
        boolean modified = false;
        for (V v : c) {
            if (!this.addIfAbsent(v)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        return null != this.map.remove(this.uniqueGenerator.apply(o));
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

