/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.collection;

import java.util.Iterator;
import java.util.function.Function;
import top.redscorpion.core.lang.Assert;

public class TransIter<F, T>
implements Iterator<T> {
    private final Iterator<? extends F> backingIterator;
    private final Function<? super F, ? extends T> func;

    public TransIter(Iterator<? extends F> backingIterator, Function<? super F, ? extends T> func) {
        this.backingIterator = Assert.notNull(backingIterator);
        this.func = Assert.notNull(func);
    }

    @Override
    public final boolean hasNext() {
        return this.backingIterator.hasNext();
    }

    @Override
    public final T next() {
        return this.func.apply(this.backingIterator.next());
    }

    @Override
    public final void remove() {
        this.backingIterator.remove();
    }
}

