/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.collection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.lang.Matcher;
import top.redscorpion.core.util.RsArray;

public class ListUtil {
    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (RsArray.isEmpty(values)) {
            return ListUtil.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        List<T> list = ListUtil.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return (ArrayList)ListUtil.list(false, values);
    }

    public static <T> ArrayList<T> toList(Collection<T> collection) {
        return (ArrayList)ListUtil.list(false, collection);
    }

    public static <T> ArrayList<T> toList(Iterator<T> iterator) {
        return (ArrayList)ListUtil.list(false, iterator);
    }

    public static <T> int[] indexOfAll(List<T> list, Matcher<T> matcher) {
        return CollUtil.indexOfAll(list, matcher);
    }
}

