/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.collection;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import top.redscorpion.core.collection.ListUtil;
import top.redscorpion.core.collection.TransIter;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.func.Func1;
import top.redscorpion.core.map.MapUtil;
import top.redscorpion.core.text.StringJoiner;

public class IterUtil {
    public static <T> Iterator<T> getIter(Iterable<T> iterable) {
        return null == iterable ? null : iterable.iterator();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || IterUtil.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return null == iterator || false == iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && IterUtil.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return null != iterator && iterator.hasNext();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return StringJoiner.of(conjunction).append(iterator).toString();
    }

    public static <E> List<E> toList(Iterable<E> iter) {
        if (null == iter) {
            return null;
        }
        return IterUtil.toList(iter.iterator());
    }

    public static <E> List<E> toList(Iterator<E> iter) {
        return ListUtil.toList(iter);
    }

    public static <E> E get(Iterator<E> iterator, int index) throws IndexOutOfBoundsException {
        if (null == iterator) {
            return null;
        }
        Assert.isTrue(index >= 0, "[index] must be >= 0", new Object[0]);
        while (iterator.hasNext()) {
            if (-1 == --index) {
                return iterator.next();
            }
            iterator.next();
        }
        return null;
    }

    public static <K, V> Map<K, V> toMap(Iterator<V> iterator, Map<K, V> map, Func1<V, K> keyFunc) {
        return IterUtil.toMap(iterator, map, keyFunc, value -> value);
    }

    public static <K, V, E> Map<K, V> toMap(Iterator<E> iterator, Map<K, V> map, Func1<E, K> keyFunc, Func1<E, V> valueFunc) {
        if (null == iterator) {
            return map;
        }
        if (null == map) {
            map = MapUtil.newHashMap(true);
        }
        while (iterator.hasNext()) {
            E element = iterator.next();
            try {
                map.put(keyFunc.call(element), valueFunc.call(element));
            }
            catch (Exception e) {
                throw new RsException(e);
            }
        }
        return map;
    }

    public static <F, T> Iterator<T> trans(Iterator<F> iterator, Function<? super F, ? extends T> function) {
        return new TransIter<F, T>(iterator, function);
    }
}

