/*
 * Decompiled with CFR 0.152.
 */
package top.mangues.searchdb.mybatis;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import top.mangues.searchdb.mybatis.SearchHelper;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class SearchInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        String searchBean = SearchHelper.getSearchBean();
        RoutingStatementHandler handler = (RoutingStatementHandler)invocation.getTarget();
        StatementHandler delegate = (StatementHandler)ReflectUtil.getFieldValue(handler, "delegate");
        BoundSql boundSql = delegate.getBoundSql();
        if (searchBean != null && searchBean.length() > 1) {
            String sql;
            MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValue(delegate, "mappedStatement");
            String pageSql = sql = boundSql.getSql();
            pageSql = this.getSql(sql, new StringBuilder(searchBean.replaceAll("\"", "")));
            ReflectUtil.setFieldValue(boundSql, "sql", pageSql);
        }
        return invocation.proceed();
    }

    private String getSql(String sql, StringBuilder needStrsb) {
        StringBuffer sqlSb = new StringBuffer(sql);
        String s = sql.toLowerCase();
        int where = s.lastIndexOf("where");
        if (where == -1) {
            int group = s.lastIndexOf("group by");
            needStrsb.insert(0, " where ");
            if (group == -1) {
                int limit = s.lastIndexOf("limit");
                if (limit == -1) {
                    sqlSb.append((CharSequence)needStrsb);
                } else {
                    sqlSb.insert(limit - 1, needStrsb);
                }
            } else {
                sqlSb.insert(group - 1, needStrsb);
            }
        } else {
            sqlSb.insert(where + 5, needStrsb.append("and "));
        }
        return sqlSb.toString();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private static class ReflectUtil {
        private ReflectUtil() {
        }

        public static Object getFieldValue(Object obj, String fieldName) {
            Object result = null;
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field != null) {
                field.setAccessible(true);
                try {
                    result = field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        private static Field getField(Object obj, String fieldName) {
            Field field = null;
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            return field;
        }

        public static void setFieldValue(Object obj, String fieldName, String fieldValue) {
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field != null) {
                try {
                    field.setAccessible(true);
                    field.set(obj, fieldValue);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

