/*
 * Decompiled with CFR 0.152.
 */
package top.mangues.searchdb.aop;

import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import top.mangues.searchdb.annotion.DictParam;
import top.mangues.searchdb.annotion.SearchDb;
import top.mangues.searchdb.common.Ignore;

@Aspect
@Component
public class DictSearchAop {
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    SqlSession sqlSession;

    @Around(value="@annotation(searchDb)")
    public Object doHandle(ProceedingJoinPoint point, SearchDb searchDb) throws Throwable {
        Object obj = point.proceed();
        Class aClass = searchDb.resultClass();
        if (aClass.getName().equals(Ignore.class.getName())) {
            return obj;
        }
        Field[] declaredFields = aClass.getDeclaredFields();
        Map<String, Map<Integer, StringBuilder>> runSqlMap = this.getRunSqlMap(declaredFields);
        HashMap<String, List<Object>> variableMap = new HashMap<String, List<Object>>();
        if (obj instanceof List) {
            List listObj = (List)obj;
            for (Object e : listObj) {
                this.field2Map(e, declaredFields, variableMap);
            }
        } else {
            this.field2Map(obj, declaredFields, variableMap);
        }
        HashMap<String, Map<Object, List<Map<String, Object>>>> keyMap = new HashMap<String, Map<Object, List<Map<String, Object>>>>();
        for (Map.Entry entry : variableMap.entrySet()) {
            Map<Integer, StringBuilder> runSqlContentMap;
            StringBuilder stringBuilder;
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (ObjectUtils.isEmpty((Object)value) || (stringBuilder = (runSqlContentMap = runSqlMap.get(key)).get(0)) == null) continue;
            String join = StringUtils.join((Iterable)value, (String)",");
            stringBuilder.append("(").append(join).append(")");
            List resultMapList = SqlRunner.db().selectList(stringBuilder.toString(), new Object[0]);
            if (resultMapList == null || resultMapList.size() <= 0) continue;
            Map<Object, List<Map>> collect = resultMapList.stream().collect(Collectors.groupingBy(o -> String.valueOf(o.get(((StringBuilder)runSqlContentMap.get(1)).toString()))));
            keyMap.put(key, collect);
        }
        if (obj instanceof List) {
            List listObj = (List)obj;
            ArrayList<Map> arrayList = new ArrayList<Map>();
            for (Object object : listObj) {
                Map jsonObject = this.variable2Map(object, declaredFields, keyMap);
                arrayList.add(jsonObject);
            }
            return arrayList;
        }
        Map jsonObject = this.variable2Map(obj, declaredFields, keyMap);
        return jsonObject;
    }

    private Map<String, Map<Integer, StringBuilder>> getRunSqlMap(Field[] fieldList) throws Exception {
        HashMap<String, Map<Integer, StringBuilder>> resultMap = new HashMap<String, Map<Integer, StringBuilder>>();
        for (Field field : fieldList) {
            boolean annotationPresent = field.isAnnotationPresent(DictParam.class);
            if (!annotationPresent) continue;
            DictParam searchParam = field.getAnnotation(DictParam.class);
            StringBuilder stringBuilder = new StringBuilder("select ");
            String dictId = searchParam.dictId();
            String dictTable = searchParam.dictTable();
            String[] columns = searchParam.columns();
            String join = StringUtils.join(Arrays.asList(columns), (String)",");
            stringBuilder.append(dictId).append(",").append(join).append(" from ").append(dictTable).append(" where ").append(dictId).append(" in ");
            HashMap<Integer, StringBuilder> contentMap = new HashMap<Integer, StringBuilder>();
            contentMap.put(0, stringBuilder);
            contentMap.put(1, new StringBuilder(dictId));
            resultMap.put(field.getName(), contentMap);
        }
        return resultMap;
    }

    private void field2Map(Object obj, Field[] fieldList, Map<String, List<Object>> variableMap) throws JsonProcessingException, IllegalAccessException {
        for (Field field : fieldList) {
            boolean annotationPresent = field.isAnnotationPresent(DictParam.class);
            if (!annotationPresent) continue;
            field.setAccessible(true);
            Object object = field.get(obj);
            if (object == null) continue;
            String name = field.getName();
            List<Object> objectList = variableMap.get(name);
            if (objectList == null) {
                objectList = new ArrayList<Object>();
                variableMap.put(name, objectList);
            }
            objectList.add(object);
        }
    }

    private Map variable2Map(Object obj, Field[] fieldList, Map<String, Map<Object, List<Map<String, Object>>>> variableMap) throws Exception {
        String toJSONString = this.mapper.writeValueAsString(obj);
        Map jsonObject = (Map)this.mapper.readValue(toJSONString, Map.class);
        for (Field field : fieldList) {
            List<Map<String, Object>> maps;
            String name;
            Map<Object, List<Map<String, Object>>> objectListMap;
            boolean annotationPresent = field.isAnnotationPresent(DictParam.class);
            if (!annotationPresent) continue;
            DictParam searchParam = field.getAnnotation(DictParam.class);
            field.setAccessible(true);
            String dictId = searchParam.dictId();
            Object object = field.get(obj);
            if (object == null || (objectListMap = variableMap.get(name = field.getName())) == null || (maps = objectListMap.get(String.valueOf(object))) == null || maps.size() <= 0) continue;
            Map<String, Object> stringObjectMap = maps.get(0);
            jsonObject.put(name + "DictMap", stringObjectMap);
        }
        return jsonObject;
    }
}

