/*
 * Decompiled with CFR 0.152.
 */
package top.mangues.searchdb.aop;

import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import top.mangues.searchdb.annotion.SearchDb;
import top.mangues.searchdb.annotion.SearchParam;
import top.mangues.searchdb.annotion.SearchParamEnum;
import top.mangues.searchdb.aop.searchhandler.SymbolFactory;
import top.mangues.searchdb.aop.searchhandler.SymbolHandler;
import top.mangues.searchdb.common.Enum;
import top.mangues.searchdb.common.SearchBean;
import top.mangues.searchdb.mybatis.SearchHelper;
import top.mangues.searchdb.util.UnderLineUtil;

@Aspect
public class SearchDbAop {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(searchDb)")
    public Object doHandle(ProceedingJoinPoint point, SearchDb searchDb) throws Throwable {
        Object[] args;
        Signature sig = point.getSignature();
        MethodSignature msig = (MethodSignature)sig;
        StringBuilder stringBuilder = new StringBuilder(" ");
        HashMap<String, List<Map>> dictListMap = new HashMap<String, List<Map>>();
        for (Object obj : args = point.getArgs()) {
            if (!(obj instanceof SearchBean)) continue;
            Field[] fields = obj.getClass().getDeclaredFields();
            Field[] declaredFields = obj.getClass().getSuperclass().getDeclaredFields();
            this.field2String(stringBuilder, obj, fields, dictListMap);
            this.field2String(stringBuilder, obj, declaredFields, dictListMap);
        }
        SymbolHandler allSymbolHandler = SymbolFactory.getSymbolHandler(SearchParamEnum.in);
        for (Map.Entry dictListEntry : dictListMap.entrySet()) {
            String dictListEntryKey = (String)dictListEntry.getKey();
            List dictList = (List)dictListEntry.getValue();
            String[] dictKeySplit = dictListEntryKey.split("-");
            String dictColumn = dictKeySplit[0];
            String table = dictKeySplit[1];
            StringBuilder dictSb = new StringBuilder("select ").append(" id ").append(" from ").append(table).append(" where ");
            dictList.stream().forEach(map -> {
                String column = (String)map.get("column");
                Object data = map.get("data");
                SearchParamEnum searchParamEnum = (SearchParamEnum)((Object)((Object)map.get("searchParamEnum")));
                String dateFormat = (String)map.get("dateFormat");
                if (!dateFormat.equals("")) {
                    StringBuilder str = new StringBuilder("DATE_FORMAT(");
                    str.append(column).append(",'").append(dateFormat).append("')");
                    column = str.toString();
                }
                SymbolHandler symbolHandler = SymbolFactory.getSymbolHandler(searchParamEnum);
                symbolHandler.getNormalSymbol(dictSb, column, data, searchParamEnum);
            });
            this.removeAnd(dictSb);
            List dictResultList = SqlRunner.db().selectList(dictSb.toString(), new Object[0]);
            List collect = dictResultList.stream().map(m -> m.get("id") + "").collect(Collectors.toList());
            if (collect.size() == 0) {
                collect.add("-1");
            }
            allSymbolHandler.getNormalSymbol(stringBuilder, dictColumn, collect, SearchParamEnum.in);
        }
        this.removeAnd(stringBuilder);
        SearchHelper.startSearchBean(stringBuilder.toString());
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            SearchHelper.clearData();
        }
    }

    private void field2String(StringBuilder stringBuilder, Object obj, Field[] fieldList, Map<String, List<Map>> dictListMap) throws JsonProcessingException, IllegalAccessException {
        for (Field field : fieldList) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                String name;
                if (!(annotation instanceof SearchParam)) continue;
                SearchParam searchParam = (SearchParam)annotation;
                String column = searchParam.column();
                SearchParamEnum searchParamEnum = searchParam.symbol();
                String dateFormat = searchParam.dateFormat();
                boolean isDictColumn = searchParam.isDictColumn();
                String dictColumn = searchParam.dictColumn();
                String dictTable = searchParam.dictTable();
                String key = column;
                field.setAccessible(true);
                Object object = field.get(obj);
                if (object == null) continue;
                if (object instanceof Enum) {
                    Enum anEnum = (Enum)object;
                    String string = anEnum.string();
                    object = string;
                }
                if (isDictColumn) {
                    String dictListMapKey;
                    List<Map> dictList;
                    if (column.equals("")) {
                        name = field.getName();
                        column = UnderLineUtil.toUnderlineJSONString(name);
                    }
                    if ((dictList = dictListMap.get(dictListMapKey = dictColumn + "-" + dictTable)) == null) {
                        dictList = new ArrayList<Map>();
                        dictListMap.put(dictListMapKey, dictList);
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("column", column);
                    hashMap.put("data", object);
                    hashMap.put("searchParamEnum", (Object)searchParamEnum);
                    hashMap.put("dateFormat", dateFormat);
                    dictList.add(hashMap);
                    return;
                }
                if (column.equals("")) {
                    name = field.getName();
                    key = UnderLineUtil.toUnderlineJSONString(name);
                }
                if (!dateFormat.equals("")) {
                    StringBuilder str = new StringBuilder("DATE_FORMAT(");
                    str.append(key).append(",'").append(dateFormat).append("')");
                    key = str.toString();
                }
                SymbolHandler symbolHandler = SymbolFactory.getSymbolHandler(searchParamEnum);
                symbolHandler.getNormalSymbol(stringBuilder, key, object, searchParamEnum);
            }
        }
    }

    private void removeAnd(StringBuilder stringBuilder) {
        int and = stringBuilder.lastIndexOf("and");
        if (and > 0) {
            stringBuilder.delete(and, stringBuilder.length());
        }
    }
}

