/*
 * Decompiled with CFR 0.152.
 */
package top.lrshuai.encryption;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class MDUtil {
    public static String jdkMD5(String key) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] mdbyte = md.digest(key.getBytes());
        return Hex.encodeHexString((byte[])mdbyte);
    }

    public static String jdkMD2(String key) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD2");
        byte[] mdbyte = md.digest(key.getBytes());
        return Hex.encodeHexString((byte[])mdbyte);
    }

    public static String bcMD4(String key) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        MessageDigest md = MessageDigest.getInstance("MD4");
        byte[] mdbyte = md.digest(key.getBytes());
        return Hex.encodeHexString((byte[])mdbyte);
    }

    public static String bcMD42(String key) throws Exception {
        MD4Digest digest = new MD4Digest();
        digest.update(key.getBytes(), 0, key.getBytes().length);
        byte[] bcbtyte = new byte[digest.getDigestSize()];
        digest.doFinal(bcbtyte, 0);
        return org.bouncycastle.util.encoders.Hex.toHexString((byte[])bcbtyte);
    }

    public static String bcMD5(String key) throws Exception {
        MD5Digest digest = new MD5Digest();
        digest.update(key.getBytes(), 0, key.getBytes().length);
        byte[] bcbtyte = new byte[digest.getDigestSize()];
        digest.doFinal(bcbtyte, 0);
        return org.bouncycastle.util.encoders.Hex.toHexString((byte[])bcbtyte);
    }

    public static String ccMD5(String key) {
        return DigestUtils.md5Hex((byte[])key.getBytes());
    }

    public static String ccMD2(String key) {
        return DigestUtils.md2Hex((byte[])key.getBytes());
    }

    public static void main(String[] args) throws Exception {
        String key = "www.lrshuai.top";
        System.out.println(MDUtil.jdkMD5(key));
        System.out.println(MDUtil.jdkMD2(key));
        System.out.println(MDUtil.bcMD4(key));
        System.out.println(MDUtil.bcMD42(key));
        System.out.println(MDUtil.bcMD5(key));
        System.out.println(MDUtil.ccMD5(key));
        System.out.println(MDUtil.ccMD2(key));
    }
}

