/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.saf;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.UriPermission;
import android.net.Uri;
import androidx.documentfile.provider.DocumentFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.saf.IO;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0006J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\fJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0006J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0006J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u0018\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\u0017J0\u0010!\u001a$\u0012\f\u0012\n $*\u0004\u0018\u00010#0# $*\u0010\u0012\f\u0012\n $*\u0004\u0018\u00010#0#0%0\"2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0014J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0014H\u0002J\u001e\u0010*\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ltop/heue/utils/saf/SAF;", "", "()V", "CONFIG_PATH", "", "GRANT_REQUEST_CODE", "", "PACKAGE_NAME", "TAKE_FLAGS", "isSingleSAF", "", "getDocumentFile", "Landroidx/documentfile/provider/DocumentFile;", "activity", "Landroid/app/Activity;", "position", "name", "treeDocumentFile", "getDocumentFileTree", "getUri", "Landroid/net/Uri;", "getUriByName", "grant", "", "grantResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "init", "context", "Landroid/content/Context;", "listAll", "listUri", "", "Landroid/content/UriPermission;", "kotlin.jvm.PlatformType", "", "read", "uri", "takeUriPermission", "treeUri", "write", "content", "saf_release"})
public final class SAF {
    @NotNull
    public static final SAF INSTANCE = new SAF();
    private static final int GRANT_REQUEST_CODE = 100;
    private static String PACKAGE_NAME;
    private static final int TAKE_FLAGS = 3;
    @NotNull
    private static final String CONFIG_PATH = "/saf.config";
    private static boolean isSingleSAF;

    private SAF() {
    }

    public final void listAll() {
    }

    @Nullable
    public final String read(@NotNull Activity activity, @NotNull Uri uri) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        InputStream inputStream2 = activity.getContentResolver().openInputStream(uri);
        if (inputStream2 == null) {
            return null;
        }
        InputStream input = inputStream = inputStream2;
        return IO.INSTANCE.read(input);
    }

    public final boolean write(@NotNull Activity activity, @NotNull Uri uri, @NotNull String content) {
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        OutputStream outputStream2 = activity.getContentResolver().openOutputStream(uri);
        if (outputStream2 == null) {
            return false;
        }
        OutputStream output = outputStream = outputStream2;
        IO.write$default(IO.INSTANCE, output, content, false, 4, null);
        return true;
    }

    public final void grant(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intent i = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
        activity.startActivityForResult(i, 100);
    }

    public final void grantResult(@NotNull Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (resultCode != -1) {
            return;
        }
        if (requestCode != 100) {
            return;
        }
        if (data == null) {
            return;
        }
        if (isSingleSAF) {
            List<UriPermission> pup = this.listUri(activity);
            for (UriPermission up : pup) {
                activity.revokeUriPermission(up.getUri(), 3);
            }
        }
        Uri uri = data.getData();
        Intrinsics.checkNotNull((Object)uri);
        Object object2 = uri;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"data.data!!");
        Object treeUri = object2;
        object2 = PACKAGE_NAME;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"PACKAGE_NAME");
            object = null;
        } else {
            object = object2;
        }
        activity.grantUriPermission((String)object, (Uri)treeUri, 3);
        this.takeUriPermission(activity, (Uri)treeUri);
    }

    @Nullable
    public final Uri getUriByName(@NotNull Activity activity, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<UriPermission> pup = this.listUri(activity);
        for (UriPermission up : pup) {
            String uriStr;
            String string = up.getUri().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"up.uri.toString()");
            string = uriStr = string;
            int n = StringsKt.indexOf$default((CharSequence)uriStr, (String)"%3A", (int)0, (boolean)false, (int)6, null) + 3;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            uriStr = string2;
            if (StringsKt.indexOf$default((CharSequence)uriStr, (String)name, (int)0, (boolean)false, (int)6, null) != 0) continue;
            return up.getUri();
        }
        return null;
    }

    @Nullable
    public final DocumentFile getDocumentFile(@NotNull Activity activity, int position) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Uri uri = this.getUri(activity, position);
        return uri != null ? DocumentFile.fromSingleUri((Context)((Context)activity), (Uri)uri) : null;
    }

    public static /* synthetic */ DocumentFile getDocumentFile$default(SAF sAF, Activity activity, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return sAF.getDocumentFile(activity, n);
    }

    @Nullable
    public final DocumentFile getDocumentFile(@NotNull Activity activity, @NotNull String name, @Nullable DocumentFile treeDocumentFile) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DocumentFile documentFile = treeDocumentFile;
        if (documentFile != null) {
            DocumentFile documentFile2 = documentFile;
            boolean bl = false;
            boolean bl2 = false;
            DocumentFile it = documentFile2;
            boolean bl3 = false;
            return it.findFile(name);
        }
        Uri uri = this.getUriByName(activity, name);
        return uri != null ? DocumentFile.fromSingleUri((Context)((Context)activity), (Uri)uri) : null;
    }

    @Nullable
    public final DocumentFile getDocumentFileTree(@NotNull Activity activity, int position) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Uri uri = this.getUri(activity, position);
        return uri != null ? DocumentFile.fromTreeUri((Context)((Context)activity), (Uri)uri) : null;
    }

    public static /* synthetic */ DocumentFile getDocumentFileTree$default(SAF sAF, Activity activity, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return sAF.getDocumentFileTree(activity, n);
    }

    @Nullable
    public final DocumentFile getDocumentFileTree(@NotNull Activity activity, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Uri uri = this.getUriByName(activity, name);
        return uri != null ? DocumentFile.fromTreeUri((Context)((Context)activity), (Uri)uri) : null;
    }

    @Nullable
    public final Uri getUri(@NotNull Activity activity, int position) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        List<UriPermission> pup = this.listUri(activity);
        if (pup.size() == 0) {
            return null;
        }
        return pup.get(position).getUri();
    }

    public static /* synthetic */ Uri getUri$default(SAF sAF, Activity activity, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return sAF.getUri(activity, n);
    }

    @NotNull
    public final List<UriPermission> listUri(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        List list = activity.getContentResolver().getPersistedUriPermissions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"activity.contentResolver.persistedUriPermissions");
        return list;
    }

    public final void init(@NotNull Context context, boolean isSingleSAF) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SAF.isSingleSAF = isSingleSAF;
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        PACKAGE_NAME = string;
        IO.INSTANCE.init(context);
    }

    public static /* synthetic */ void init$default(SAF sAF, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        sAF.init(context, bl);
    }

    private final void takeUriPermission(Activity activity, Uri treeUri) {
        activity.getContentResolver().takePersistableUriPermission(treeUri, 3);
    }
}

