/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.log;

import android.os.Handler;
import android.os.Looper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.log.IL;
import top.heue.utils.log.LogLevel;
import top.heue.utils.log.TaskPool;
import top.heue.utils.log.base.IBaseHandler;
import top.heue.utils.log.base.IBasePrinter;
import top.heue.utils.log.base.ILRuntime;
import top.heue.utils.log.handler.BundleHandler;
import top.heue.utils.log.handler.JSONHandler;
import top.heue.utils.log.handler.StringHandler;
import top.heue.utils.log.handler.ThrowableHandler;
import top.heue.utils.log.printer.DefaultPrinter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0016J\u001a\u0010+\u001a\u00020\n2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u0015JB\u0010/\u001a\u00020\u000028\u00100\u001a4\u0012\u0015\u0012\u0013\u0018\u000102\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020%01H\u0016J%\u00107\u001a\u00020%2\u0016\u00108\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-09\"\u0004\u0018\u00010-H\u0007\u00a2\u0006\u0002\u0010:J\u001a\u00107\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00052\b\u00108\u001a\u0004\u0018\u00010-H\u0007J%\u0010;\u001a\u00020%2\u0016\u00108\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-09\"\u0004\u0018\u00010-H\u0007\u00a2\u0006\u0002\u0010:J\u001a\u0010;\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00052\b\u00108\u001a\u0004\u0018\u00010-H\u0007J5\u0010<\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-2\u0016\u00108\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-09\"\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010=J%\u0010>\u001a\u00020%2\u0016\u00108\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-09\"\u0004\u0018\u00010-H\u0007\u00a2\u0006\u0002\u0010:J\u001a\u0010>\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00052\b\u00108\u001a\u0004\u0018\u00010-H\u0007J\u0010\u0010?\u001a\u00020\u00052\u0006\u0010;\u001a\u00020!H\u0007J%\u0010@\u001a\u00020%2\u0016\u00108\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-09\"\u0004\u0018\u00010-H\u0007\u00a2\u0006\u0002\u0010:J\u001a\u0010@\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00052\b\u00108\u001a\u0004\u0018\u00010-H\u0007J%\u0010A\u001a\u00020%2\u0016\u00108\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-09\"\u0004\u0018\u00010-H\u0007\u00a2\u0006\u0002\u0010:J\u001a\u0010A\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00052\b\u00108\u001a\u0004\u0018\u00010-H\u0007R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u0016\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u00020\u0005*\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006B"}, d2={"Ltop/heue/utils/log/L;", "Ltop/heue/utils/log/IL;", "()V", "TAG", "Lkotlin/Pair;", "", "getTAG", "()Lkotlin/Pair;", "apartMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "current", "kotlin.jvm.PlatformType", "getCurrent", "logLevel", "Ltop/heue/utils/log/LogLevel;", "getLogLevel", "()Ltop/heue/utils/log/LogLevel;", "setLogLevel", "(Ltop/heue/utils/log/LogLevel;)V", "loggable", "", "getLoggable", "()Z", "setLoggable", "(Z)V", "runtime", "Ltop/heue/utils/log/base/ILRuntime;", "getRuntime", "()Ltop/heue/utils/log/base/ILRuntime;", "setRuntime", "(Ltop/heue/utils/log/base/ILRuntime;)V", "string", "", "getString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "addHandler", "", "handler", "Ltop/heue/utils/log/base/IBaseHandler;", "addPrinter", "printer", "Ltop/heue/utils/log/base/IBasePrinter;", "apart", "tag", "", "isRemove", "catchError", "threadHandler", "Lkotlin/Function2;", "Ljava/lang/Thread;", "Lkotlin/ParameterName;", "name", "thread", "throwable", "d", "any", "", "([Ljava/lang/Object;)V", "e", "handle", "(Ltop/heue/utils/log/LogLevel;Ljava/lang/Object;[Ljava/lang/Object;)V", "i", "throwToString", "v", "w", "log_release"})
public final class L
implements IL {
    @NotNull
    public static final L INSTANCE;
    private static boolean loggable;
    @NotNull
    private static LogLevel logLevel;
    @Nullable
    private static ILRuntime runtime;
    @NotNull
    private static ConcurrentHashMap<String, Long> apartMap;

    private L() {
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, String> getTAG() {
        void var3_3;
        L $this$_get_TAG__u24lambda_u241 = this;
        boolean bl = false;
        Pair ret = null;
        Pair<String, String> it = $this$_get_TAG__u24lambda_u241.getCurrent();
        boolean bl2 = false;
        Object object = it.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
        char[] cArray = new char[]{'.'};
        List s = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        ret = TuplesKt.to(s.get(s.size() - 2), (Object)it.getSecond());
        return var3_3;
    }

    @Override
    public boolean getLoggable() {
        return loggable;
    }

    @Override
    public void setLoggable(boolean bl) {
        loggable = bl;
    }

    @Override
    @NotNull
    public LogLevel getLogLevel() {
        return logLevel;
    }

    @Override
    public void setLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        L.logLevel = logLevel;
    }

    @Override
    @Nullable
    public ILRuntime getRuntime() {
        return runtime;
    }

    @Override
    public void setRuntime(@Nullable ILRuntime iLRuntime) {
        runtime = iLRuntime;
    }

    @Override
    public void handle(@NotNull LogLevel logLevel, @NotNull Object tag, Object ... any) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        if (!this.getLoggable()) {
            return;
        }
        if (logLevel.getLevel() < this.getLogLevel().getLevel()) {
            return;
        }
        Function0 block2 = (Function0)new Function0<Unit>(any, tag, logLevel){
            final /* synthetic */ Object[] $any;
            final /* synthetic */ Object $tag;
            final /* synthetic */ LogLevel $logLevel;
            {
                this.$any = $any;
                this.$tag = $tag;
                this.$logLevel = $logLevel;
                super(0);
            }

            public final void invoke() {
                String string;
                Object[] ret;
                if (this.$any[0] instanceof Object[]) {
                    Object object = this.$any[0];
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                    v1 = (Object[])object;
                } else {
                    v1 = ret = this.$any;
                }
                if (this.$tag instanceof Pair) {
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)String.valueOf(((Pair)this.$tag).getSecond()));
                    spreadBuilder.addSpread((Object)ret);
                    ret = spreadBuilder.toArray(new Object[spreadBuilder.size()]);
                    string = String.valueOf(((Pair)this.$tag).getFirst());
                } else {
                    string = this.$tag.toString();
                }
                String t = string;
                TaskPool.INSTANCE.execute(this.$logLevel, t, Arrays.copyOf(ret, ret.length));
            }
        };
        if (this.getRuntime() != null) {
            ILRuntime iLRuntime = this.getRuntime();
            Intrinsics.checkNotNull((Object)iLRuntime);
            iLRuntime.run((Function0<Unit>)block2);
        } else {
            block2.invoke();
        }
    }

    @Override
    public void addHandler(@NotNull IBaseHandler<?> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        TaskPool.INSTANCE.add(handler);
    }

    @Override
    public void addPrinter(@NotNull IBasePrinter printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        TaskPool.INSTANCE.add(printer);
    }

    @JvmStatic
    public static final void v(Object ... any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        INSTANCE.handle(LogLevel.VERBOSE, INSTANCE.getTAG(), Arrays.copyOf(any, any.length));
    }

    @JvmStatic
    public static final void v(@NotNull String tag, @Nullable Object any) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object[] objectArray = new Object[]{any};
        INSTANCE.handle(LogLevel.VERBOSE, tag, objectArray);
    }

    @JvmStatic
    public static final void d(Object ... any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        INSTANCE.handle(LogLevel.DEBUG, INSTANCE.getTAG(), Arrays.copyOf(any, any.length));
    }

    @JvmStatic
    public static final void d(@NotNull String tag, @Nullable Object any) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object[] objectArray = new Object[]{any};
        INSTANCE.handle(LogLevel.DEBUG, tag, objectArray);
    }

    @JvmStatic
    public static final void i(Object ... any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        INSTANCE.handle(LogLevel.INFO, INSTANCE.getTAG(), Arrays.copyOf(any, any.length));
    }

    @JvmStatic
    public static final void i(@NotNull String tag, @Nullable Object any) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object[] objectArray = new Object[]{any};
        INSTANCE.handle(LogLevel.INFO, tag, objectArray);
    }

    @JvmStatic
    public static final void w(Object ... any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        INSTANCE.handle(LogLevel.WARN, INSTANCE.getTAG(), Arrays.copyOf(any, any.length));
    }

    @JvmStatic
    public static final void w(@NotNull String tag, @Nullable Object any) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object[] objectArray = new Object[]{any};
        INSTANCE.handle(LogLevel.WARN, tag, objectArray);
    }

    @JvmStatic
    public static final void e(Object ... any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        INSTANCE.handle(LogLevel.ERROR, INSTANCE.getTAG(), Arrays.copyOf(any, any.length));
    }

    @JvmStatic
    public static final void e(@NotNull String tag, @Nullable Object any) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object[] objectArray = new Object[]{any};
        INSTANCE.handle(LogLevel.ERROR, tag, objectArray);
    }

    @JvmStatic
    @NotNull
    public static final String throwToString(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    @Override
    @NotNull
    public String getString(@NotNull Throwable $this$string) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        return L.throwToString($this$string);
    }

    public final long apart(@NotNull Object tag, boolean isRemove) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        L $this$apart_u24lambda_u243 = this;
        boolean bl = false;
        long result = 0L;
        String apartTag = tag.toString();
        if (apartMap.get(apartTag) == null) {
            ((Map)apartMap).put(apartTag, System.currentTimeMillis());
        } else {
            long c = System.currentTimeMillis();
            Long l = apartMap.get(apartTag);
            Intrinsics.checkNotNull((Object)l);
            result = c - ((Number)l).longValue();
            if (isRemove) {
                apartMap.remove(apartTag);
            } else {
                Long l2 = c;
                ((Map)apartMap).put(apartTag, l2);
            }
        }
        return result;
    }

    public static /* synthetic */ long apart$default(L l, Object object, boolean bl, int n, Object object2) {
        if ((n & 1) != 0) {
            object = 0;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return l.apart(object, bl);
    }

    @Override
    @NotNull
    public Pair<String, String> getCurrent() {
        L $this$_get_current__u24lambda_u244 = this;
        boolean bl = false;
        StringBuffer forResult = new StringBuffer("");
        Throwable throwable = new Throwable();
        String throwableString = ExceptionsKt.stackTraceToString((Throwable)throwable);
        char[] cArray = new char[]{'\n'};
        List arr = StringsKt.split$default((CharSequence)throwableString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean nearCurrent = false;
        String forMethodName = "";
        int offset = 0;
        int n = arr.size();
        for (int pos = 0; pos < n; ++pos) {
            if (nearCurrent) {
                CharSequence charSequence = (CharSequence)arr.get(pos + 1);
                String string = $this$_get_current__u24lambda_u244.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.name");
                if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                    offset = 2;
                }
                CharSequence charSequence2 = (CharSequence)arr.get(pos + offset);
                String string2 = $this$_get_current__u24lambda_u244.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
                if (StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)string2, (boolean)false, (int)2, null)) {
                    offset = 1;
                }
                String string3 = throwable.getStackTrace()[pos - 1 + offset].getMethodName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"throwable.stackTrace[pos - 1 + offset].methodName");
                forMethodName = string3;
                forResult.append((String)arr.get(pos + offset));
                break;
            }
            CharSequence charSequence = (CharSequence)arr.get(pos);
            String string = $this$_get_current__u24lambda_u244.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.name");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) continue;
            nearCurrent = true;
        }
        int s = forResult.indexOf("at ") + 3;
        int e = StringsKt.indexOf$default((CharSequence)forResult, (char)'(', (int)0, (boolean)false, (int)6, null);
        String res = forResult.substring(s, e);
        return TuplesKt.to((Object)res, (Object)forMethodName);
    }

    @Override
    @NotNull
    public L catchError(@NotNull Function2<? super Thread, ? super Throwable, Unit> threadHandler) {
        L l;
        Intrinsics.checkNotNullParameter(threadHandler, (String)"threadHandler");
        L $this$catchError_u24lambda_u247 = l = this;
        boolean bl = false;
        new Handler(Looper.getMainLooper()).post(() -> L.catchError$lambda$7$lambda$5(threadHandler));
        Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> L.catchError$lambda$7$lambda$6(threadHandler, arg_0, arg_1));
        return l;
    }

    private static final void catchError$lambda$7$lambda$5(Function2 $threadHandler) {
        Intrinsics.checkNotNullParameter((Object)$threadHandler, (String)"$threadHandler");
        while (true) {
            try {
                Looper.loop();
                continue;
            }
            catch (Throwable e) {
                $threadHandler.invoke(null, (Object)e);
                continue;
            }
            break;
        }
    }

    private static final void catchError$lambda$7$lambda$6(Function2 $threadHandler, Thread thread, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)$threadHandler, (String)"$threadHandler");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        $threadHandler.invoke((Object)thread, (Object)throwable);
    }

    static {
        TaskPool taskPool;
        INSTANCE = new L();
        loggable = true;
        logLevel = LogLevel.VERBOSE;
        TaskPool $this$_init__u24lambda_u242 = taskPool = TaskPool.INSTANCE;
        boolean bl = false;
        $this$_init__u24lambda_u242.add(new StringHandler());
        $this$_init__u24lambda_u242.add(new ThrowableHandler());
        $this$_init__u24lambda_u242.add(new JSONHandler());
        $this$_init__u24lambda_u242.add(new BundleHandler());
        $this$_init__u24lambda_u242.add(new DefaultPrinter());
        apartMap = new ConcurrentHashMap();
    }
}

