/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.log.pool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import top.heue.utils.log.LogLevel;
import top.heue.utils.log.base.IBaseHandler;
import top.heue.utils.log.base.IBasePrinter;
import top.heue.utils.log.pool.ITaskPool;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J5\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u0011\"\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u0011\"\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0016R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltop/heue/utils/log/pool/TaskPool;", "Ltop/heue/utils/log/pool/ITaskPool;", "()V", "handlers", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ltop/heue/utils/log/base/IBaseHandler;", "printers", "Ltop/heue/utils/log/base/IBasePrinter;", "add", "", "item", "execute", "logLevel", "Ltop/heue/utils/log/LogLevel;", "tag", "", "any", "", "", "(Ltop/heue/utils/log/LogLevel;Ljava/lang/String;[Ljava/lang/Object;)V", "format", "([Ljava/lang/Object;)Ljava/lang/String;", "print", "string", "log_release"})
public final class TaskPool
implements ITaskPool {
    @NotNull
    public static final TaskPool INSTANCE = new TaskPool();
    @NotNull
    private static final ConcurrentLinkedDeque<IBaseHandler<?>> handlers = new ConcurrentLinkedDeque();
    @NotNull
    private static final ConcurrentLinkedDeque<IBasePrinter> printers = new ConcurrentLinkedDeque();

    private TaskPool() {
    }

    @Override
    public void add(@NotNull IBaseHandler<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        IBaseHandler<?> iBaseHandler = handlers.peekLast();
        if (iBaseHandler != null) {
            iBaseHandler.next(item);
        }
        handlers.add(item);
    }

    @Override
    public void add(@NotNull IBasePrinter item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        IBasePrinter iBasePrinter = printers.peekLast();
        if (iBasePrinter != null) {
            iBasePrinter.next(item);
        }
        printers.add(item);
    }

    @Override
    public void execute(@NotNull LogLevel logLevel, @NotNull String tag, Object ... any) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        String s = this.format(Arrays.copyOf(any, any.length));
        this.print(logLevel, tag, s);
    }

    @Override
    @NotNull
    public String format(Object ... any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        TaskPool $this$format_u24lambda_u240 = this;
        boolean bl = false;
        List ret = new ArrayList();
        for (Object it : any) {
            String string = handlers.peekFirst().execute(it);
            Intrinsics.checkNotNull((Object)string);
            ret.add(StringsKt.replace$default((String)string, (String)"\n", (String)"\n\u2503", (boolean)false, (int)4, null));
        }
        return CollectionsKt.joinToString$default((Iterable)ret, (CharSequence)"\n\u2503", (CharSequence)"\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\n\u2503", (CharSequence)"\n\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (int)0, null, null, (int)56, null);
    }

    @Override
    public void print(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            IBasePrinter iBasePrinter = printers.peekFirst();
            if (iBasePrinter == null) break block0;
            iBasePrinter.execute(logLevel, tag, string);
        }
    }
}

