/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.log.pool;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.log.LogLevel;
import top.heue.utils.log.base.IBaseHandler;
import top.heue.utils.log.base.IBasePrinter;
import top.heue.utils.log.pool.ITaskPool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\"\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltop/heue/utils/log/pool/TaskPool;", "Ltop/heue/utils/log/pool/ITaskPool;", "()V", "handlers", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ltop/heue/utils/log/base/IBaseHandler;", "pool", "Landroid/os/Handler;", "printers", "Ltop/heue/utils/log/base/IBasePrinter;", "add", "", "item", "execute", "logLevel", "Ltop/heue/utils/log/LogLevel;", "tag", "", "any", "", "string", "log_release"})
public final class TaskPool
implements ITaskPool {
    @NotNull
    public static final TaskPool INSTANCE = new TaskPool();
    @NotNull
    private static final Handler pool;
    @NotNull
    private static final ConcurrentLinkedDeque<IBaseHandler> handlers;
    @NotNull
    private static final ConcurrentLinkedDeque<IBasePrinter> printers;

    private TaskPool() {
    }

    @Override
    public void add(@NotNull IBaseHandler item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        IBaseHandler iBaseHandler = handlers.peekLast();
        if (iBaseHandler != null) {
            iBaseHandler.next(item);
        }
        handlers.add(item);
    }

    @Override
    public void add(@NotNull IBasePrinter item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        IBasePrinter iBasePrinter = printers.peekLast();
        if (iBasePrinter != null) {
            iBasePrinter.next(item);
        }
        printers.add(item);
    }

    @Override
    public void execute(@NotNull LogLevel logLevel, @NotNull String tag, @Nullable Object any) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        pool.post(() -> TaskPool.execute$lambda-0(logLevel, tag, any));
    }

    @Override
    public void execute(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        pool.post(() -> TaskPool.execute$lambda-1(logLevel, tag, string));
    }

    private static final void execute$lambda-0(LogLevel $logLevel, String $tag, Object $any) {
        Intrinsics.checkNotNullParameter((Object)((Object)$logLevel), (String)"$logLevel");
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        Object object = handlers.peekFirst();
        if (object == null || (object = object.execute($logLevel, $tag, $any)) == null) {
            return;
        }
        Object str = object;
        INSTANCE.execute($logLevel, $tag, (String)str);
    }

    private static final void execute$lambda-1(LogLevel $logLevel, String $tag, String $string) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)$logLevel), (String)"$logLevel");
            Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
            Intrinsics.checkNotNullParameter((Object)$string, (String)"$string");
            IBasePrinter iBasePrinter = printers.peekFirst();
            if (iBasePrinter == null) break block0;
            iBasePrinter.execute($logLevel, $tag, $string);
        }
    }

    static {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        pool = new Handler(looper);
        handlers = new ConcurrentLinkedDeque();
        printers = new ConcurrentLinkedDeque();
    }
}

