/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.util.system;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\"\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0004\u00a8\u0006\u0012"}, d2={"Ltop/heue/utils/base/util/system/ProcessUtil;", "", "()V", "getMainProcessName", "", "context", "Landroid/content/Context;", "getRunningAppProcesses", "", "Landroid/app/ActivityManager$RunningAppProcessInfo;", "isMainProcess", "", "isPidOfProcessName", "pid", "", "pName", "isServiceRunning", "serviceName", "base_release"})
public final class ProcessUtil {
    @NotNull
    public static final ProcessUtil INSTANCE = new ProcessUtil();

    private ProcessUtil() {
    }

    public final boolean isServiceRunning(@NotNull Context context, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager manager = (ActivityManager)object;
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!Intrinsics.areEqual((Object)serviceName, (Object)service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public final boolean isMainProcess(@Nullable Context context) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        return this.isPidOfProcessName(context2, Process.myPid(), this.getMainProcessName(context));
    }

    private final String getMainProcessName(Context context) {
        return context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).processName;
    }

    private final boolean isPidOfProcessName(Context context, int pid, String pName) {
        if (pName == null) {
            return false;
        }
        boolean isMain = false;
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager am = (ActivityManager)object;
        for (ActivityManager.RunningAppProcessInfo process : am.getRunningAppProcesses()) {
            if (process.pid != pid) continue;
            if (!Intrinsics.areEqual((Object)process.processName, (Object)pName)) break;
            isMain = true;
            break;
        }
        return isMain;
    }

    @NotNull
    public final List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager am = (ActivityManager)object;
        List list = am.getRunningAppProcesses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"am.runningAppProcesses");
        return list;
    }
}

