/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.util.file;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Environment;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0017J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\tJ*\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J*\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u0017R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001e"}, d2={"Ltop/heue/utils/base/util/file/FileUtil;", "", "()V", "PATH", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getPATH", "()Ljava/io/File;", "SDK_STATE", "", "getSDK_STATE", "()Z", "STATE", "getSTATE", "delete", "", "file", "inputStreamToString", "", "inputStream", "Ljava/io/InputStream;", "read", "charset", "Ljava/nio/charset/Charset;", "path", "write", "to", "from", "append", "content", "base_release"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();
    @SuppressLint(value={"AnnotateVersionCheck"})
    private static final boolean SDK_STATE = Build.VERSION.SDK_INT >= 30;
    @SuppressLint(value={"NewApi"})
    private static final File PATH = SDK_STATE ? Environment.getStorageDirectory() : Environment.getExternalStorageDirectory();
    @SuppressLint(value={"NewApi"})
    private static final boolean STATE = SDK_STATE ? Environment.isExternalStorageManager() : Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted");

    private FileUtil() {
    }

    public final boolean getSDK_STATE() {
        return SDK_STATE;
    }

    public final File getPATH() {
        return PATH;
    }

    public final boolean getSTATE() {
        return STATE;
    }

    @NotNull
    public final String inputStreamToString(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buffer);
            boolean bl = false;
            length = it;
            if (n == -1) break;
            result.write(buffer, 0, length);
        }
        inputStream.close();
        String string = result.toString(StandardCharsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString(StandardCharsets.UTF_8.name())");
        return string;
    }

    @NotNull
    public final String read(@NotNull String path, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return this.read(new File(path), charset);
    }

    public static /* synthetic */ String read$default(FileUtil fileUtil, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"defaultCharset()");
            charset = charset2;
        }
        return fileUtil.read(string, charset);
    }

    @NotNull
    public final String read(@NotNull File file, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        StringBuffer result = new StringBuffer("");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while (true) {
            String string;
            String it = string = br.readLine();
            boolean bl = false;
            line = it;
            if (string == null) break;
            result.append('\n' + line);
        }
        br.close();
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    public static /* synthetic */ String read$default(FileUtil fileUtil, File file, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"defaultCharset()");
            charset = charset2;
        }
        return fileUtil.read(file, charset);
    }

    public final void write(@NotNull String path, @NotNull String content, boolean append, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.write(new File(path), content, append, charset);
    }

    public static /* synthetic */ void write$default(FileUtil fileUtil, String string, String string2, boolean bl, Charset charset, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            Charset charset2 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"defaultCharset()");
            charset = charset2;
        }
        fileUtil.write(string, string2, bl, charset);
    }

    public final void write(@NotNull File to, @NotNull InputStream from, boolean append) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (to.exists()) {
            to.delete();
        }
        String string = to.getParent();
        if (string != null) {
            String it = string;
            boolean bl = false;
            File p = new File(it);
            if (!p.exists()) {
                p.createNewFile();
            }
        }
        to.createNewFile();
        FileOutputStream fos = new FileOutputStream(to, append);
        byte[] buffer = new byte[1024];
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        int len = 0;
        while (true) {
            int n;
            int it = n = from.read(buffer);
            boolean bl = false;
            len = it;
            if (n == -1) break;
            bos.write(buffer, 0, len);
        }
        bos.flush();
        bos.close();
        from.close();
    }

    public static /* synthetic */ void write$default(FileUtil fileUtil, File file, InputStream inputStream, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        fileUtil.write(file, inputStream, bl);
    }

    public final void write(@NotNull File file, @NotNull String content, boolean append, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(file, append);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, charset);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(content);
        bw.flush();
        bw.close();
    }

    public static /* synthetic */ void write$default(FileUtil fileUtil, File file, String string, boolean bl, Charset charset, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            Charset charset2 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"defaultCharset()");
            charset = charset2;
        }
        fileUtil.write(file, string, bl, charset);
    }

    public final void delete(@NotNull File file) {
        File[] files;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (files != null) {
            File[] $this$forEach$iv = files = file.listFiles();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                INSTANCE.delete(it);
            }
        }
        file.delete();
    }
}

