/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.helper;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.UriPermission;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.documentfile.provider.DocumentFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0010\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltop/heue/utils/base/helper/SAFHelper;", "", "activity", "Landroidx/activity/ComponentActivity;", "(Landroidx/activity/ComponentActivity;)V", "copyFile", "Ljava/io/File;", "uri", "Landroid/net/Uri;", "file", "getFilePath", "", "fileUri", "getFileRealNameFromUri", "getPath", "selection", "readFileToString", "Companion", "Grant", "base_release"})
public final class SAFHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentActivity activity;

    public SAFHelper(@NotNull ComponentActivity activity2) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        this.activity = activity2;
    }

    @NotNull
    public final String readFileToString(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        InputStream inputStream = this.activity.getContentResolver().openInputStream(uri);
        if (inputStream == null) {
            return "";
        }
        InputStream stream = inputStream;
        return Companion.inputStreamToString(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File copyFile(@NotNull Uri uri, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = this.activity.getContentResolver().openInputStream(uri);
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            BufferedInputStream bis = new BufferedInputStream(inputStream, 16);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, false), 16);
            int size = 0;
            byte[] buffer = new byte[10240];
            while (true) {
                int n;
                int it = n = bis.read(buffer);
                boolean bl2 = false;
                size = it;
                if (n == -1) break;
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bis.close();
            bos.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return file;
    }

    @NotNull
    public final String getFileRealNameFromUri(@Nullable Uri fileUri) {
        if (fileUri == null) {
            return "";
        }
        DocumentFile documentFile = DocumentFile.fromSingleUri((Context)((Context)this.activity), (Uri)fileUri);
        if (documentFile == null) {
            return "";
        }
        DocumentFile documentFile2 = documentFile;
        String string = documentFile2.getName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String getFilePath(@Nullable Uri fileUri) {
        if (fileUri == null) {
            return "";
        }
        String path = "";
        if (StringsKt.equals((String)"file", (String)fileUri.getScheme(), (boolean)true)) {
            path = String.valueOf(fileUri.getPath());
        } else if (DocumentsContract.isDocumentUri((Context)((Context)this.activity), (Uri)fileUri)) {
            String docId = DocumentsContract.getDocumentId((Uri)fileUri);
            if (Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)fileUri.getAuthority())) {
                Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                String[] stringArray = new String[]{":"};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)docId, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                String id2 = stringArray2[1];
                String selection = "_id=" + id2;
                Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"EXTERNAL_CONTENT_URI");
                path = this.getPath(uri, selection).toString();
            } else if (Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)fileUri.getAuthority())) {
                Uri uri = Uri.parse((String)"content://downloads/public_downloads");
                Long l = Long.valueOf(docId);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(docId)");
                Uri uri2 = ContentUris.withAppendedId((Uri)uri, (long)((Number)l).longValue());
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"withAppendedId(\n        \u2026Id)\n                    )");
                Uri contentUri = uri2;
                path = this.getPath(contentUri, "").toString();
            }
        } else if (StringsKt.equals((String)"content", (String)fileUri.getScheme(), (boolean)true)) {
            path = this.getPath(fileUri, "").toString();
        }
        return path;
    }

    private final String getPath(Uri uri, String selection) {
        int p;
        String path = "";
        Cursor cursor = this.activity.getContentResolver().query(uri, null, selection, null, null);
        Intrinsics.checkNotNull((Object)cursor);
        Cursor cursor2 = cursor;
        if (cursor2.moveToFirst() && (p = cursor2.getColumnIndex("_data")) >= 0) {
            String string = cursor2.getString(p);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(p)");
            path = string;
        }
        cursor2.close();
        return path;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltop/heue/utils/base/helper/SAFHelper$Companion;", "", "()V", "inputStreamToString", "", "inputStream", "Ljava/io/InputStream;", "base_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String inputStreamToString(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            StringBuilder stringBuilder = new StringBuilder("");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedReader(new InputStreamReader(stream));
                Throwable throwable2 = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable2;
                    boolean bl2 = false;
                    String line = null;
                    try {
                        while (true) {
                            String string;
                            String it = string = reader.readLine();
                            boolean bl3 = false;
                            line = it;
                            if (string != null) {
                                StringBuilder stringBuilder2 = stringBuilder.append(line);
                                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001%B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0013\u001a\u00020\u000e2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ7\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002#\u0010\t\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00018\u0001\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\nJ\u0006\u0010\u001b\u001a\u00020\u000eJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001eH\u0002J&\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\t\u001a!\u0012\u0015\u0012\u0013\u0018\u00018\u0001\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltop/heue/utils/base/helper/SAFHelper$Grant;", "I", "O", "", "activity", "Landroidx/activity/ComponentActivity;", "(Landroidx/activity/ComponentActivity;)V", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "onResult", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "out", "", "packageName", "", "takeFlags", "", "get", "input", "(Ljava/lang/Object;)V", "listUri", "", "Landroid/content/UriPermission;", "contentResolver", "Landroid/content/ContentResolver;", "releaseAllGrantedUri", "releaseGrantedUri", "uri", "Landroid/net/Uri;", "takeUri", "takeUriPermission", "treeUri", "target", "contract", "Landroidx/activity/result/contract/ActivityResultContract;", "Companion", "base_release"})
    public static final class Grant<I, O> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ComponentActivity activity;
        @Nullable
        private ActivityResultLauncher<I> launcher;
        @Nullable
        private Function1<? super O, Unit> onResult;
        @NotNull
        private final String packageName;
        private final int takeFlags;

        public Grant(@NotNull ComponentActivity activity2) {
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            this.activity = activity2;
            String string = this.activity.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"activity.packageName");
            this.packageName = string;
            this.takeFlags = 3;
        }

        @NotNull
        public final Grant<I, O> target(@NotNull ActivityResultContract<I, O> contract) {
            Grant grant;
            Intrinsics.checkNotNullParameter(contract, (String)"contract");
            Grant $this$target_u24lambda_u2d1 = grant = this;
            boolean bl = false;
            $this$target_u24lambda_u2d1.launcher = $this$target_u24lambda_u2d1.activity.registerForActivityResult(contract, arg_0 -> Grant.target$lambda-1$lambda-0($this$target_u24lambda_u2d1, arg_0));
            return grant;
        }

        @NotNull
        public final Grant<I, O> onResult(@NotNull Function1<? super O, Unit> onResult) {
            Grant grant;
            Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
            Grant $this$onResult_u24lambda_u2d2 = grant = this;
            boolean bl = false;
            $this$onResult_u24lambda_u2d2.onResult = onResult;
            return grant;
        }

        private final void takeUriPermission(ComponentActivity activity2, Uri treeUri) {
            activity2.getContentResolver().takePersistableUriPermission(treeUri, this.takeFlags);
        }

        private final void takeUri(Uri uri) {
            this.activity.grantUriPermission(this.packageName, uri, this.takeFlags);
            this.takeUriPermission(this.activity, uri);
        }

        public final void releaseAllGrantedUri() {
            ContentResolver contentResolver = this.activity.getContentResolver();
            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"activity.contentResolver");
            List<UriPermission> pup = this.listUri(contentResolver);
            for (UriPermission up : pup) {
                this.activity.revokeUriPermission(up.getUri(), this.takeFlags);
            }
        }

        public final void releaseGrantedUri(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.activity.revokeUriPermission(uri, this.takeFlags);
        }

        public final void get(@Nullable I input) {
            Grant $this$get_u24lambda_u2d3 = this;
            boolean bl = false;
            if ($this$get_u24lambda_u2d3.launcher == null) {
                throw new UninitializedPropertyAccessException("\u672a\u8c03\u7528target()\u8bbe\u7f6e\u542f\u52a8\u76ee\u7684");
            }
            ActivityResultLauncher<I> activityResultLauncher = $this$get_u24lambda_u2d3.launcher;
            Intrinsics.checkNotNull(activityResultLauncher);
            activityResultLauncher.launch(input);
        }

        public static /* synthetic */ void get$default(Grant grant, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = null;
            }
            grant.get(object);
        }

        @NotNull
        public final List<UriPermission> listUri(@NotNull ContentResolver contentResolver) {
            Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
            List list = contentResolver.getPersistedUriPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"contentResolver.persistedUriPermissions");
            return list;
        }

        private static final void target$lambda-1$lambda-0(Grant $this_apply, Object it) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
                Function1 function1 = $this_apply.onResult;
                if (function1 == null) break block0;
                function1.invoke(it);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ltop/heue/utils/base/helper/SAFHelper$Grant$Companion;", "", "()V", "with", "Ltop/heue/utils/base/helper/SAFHelper$Grant;", "I", "O", "activity", "Landroidx/activity/ComponentActivity;", "base_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <I, O> Grant<I, O> with(@NotNull ComponentActivity activity2) {
                Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
                return new Grant(activity2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

