/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.render;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.render.context.RenderContext;

public class Scaler {
    private final double anchorX;
    private final double anchorY;
    private final double factor;
    private RenderContext context;

    @NotNull
    public static Scaler create(double anchorX, double anchorY, double factor) {
        return new Scaler(anchorX, anchorY, factor);
    }

    private Scaler(double anchorX, double anchorY, double factor) {
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        if (factor <= 0.0) {
            throw new IllegalArgumentException("factor should be greater than 0, but " + factor + " found");
        }
        this.factor = factor;
    }

    public void apply(RenderContext context) {
        this.context = context;
        this.context.pushPose();
        this.context.translate(-this.anchorX * this.factor, -this.anchorY * this.factor, 0.0);
        this.context.scale(this.factor, this.factor, 1.0);
        this.context.translate(this.anchorX / this.factor, this.anchorY / this.factor, 0.0);
    }

    public void restore() {
        if (this.context == null) {
            throw new RuntimeException("Scaler: Calling restore before calling apply");
        }
        this.context.popPose();
    }

    public RenderContext getRenderContext() {
        return Objects.requireNonNull(this.context);
    }
}

