/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture.camera;

import android.hardware.Camera;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.camera.CameraFacing;

public final class OpenCamera {
    private static final Logger LOG = LoggerFactory.getLogger(OpenCamera.class);
    private final int index;
    private final Camera camera;
    private final CameraFacing facing;
    private final int orientation;

    static OpenCamera open(int cameraId) {
        Camera.CameraInfo cameraInfo;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            LOG.error("No cameras!");
            return null;
        }
        if (cameraId >= numCameras) {
            LOG.error("Requested camera does not exist: #{}", (Object)cameraId);
            return null;
        }
        if (cameraId < 0) {
            for (cameraId = 0; cameraId < numCameras; ++cameraId) {
                cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
                if (CameraFacing.values()[cameraInfo.facing] == CameraFacing.BACK) break;
            }
            if (cameraId == numCameras) {
                LOG.debug("No camera facing {}; returning camera #0", (Object)CameraFacing.BACK);
                cameraId = 0;
            }
        }
        LOG.debug("Opening camera #{}", (Object)cameraId);
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        Camera camera = Camera.open((int)cameraId);
        if (camera == null) {
            return null;
        }
        return new OpenCamera(cameraId, camera, CameraFacing.values()[cameraInfo.facing], cameraInfo.orientation);
    }

    private OpenCamera(int index, Camera camera, CameraFacing facing, int orientation) {
        this.index = index;
        this.camera = camera;
        this.facing = facing;
        this.orientation = orientation;
    }

    boolean isFront() {
        return this.facing == CameraFacing.FRONT;
    }

    public Camera getCamera() {
        return this.camera;
    }

    int getOrientation() {
        return this.orientation;
    }

    public String toString() {
        return "Camera#" + this.index + ':' + (Object)((Object)this.facing) + ',' + this.orientation;
    }
}

