/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture.camera;

import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Handler;
import android.view.SurfaceHolder;
import com.google.zxing.PlanarYUVLuminanceSource;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.CaptureActivity;
import top.fullj.zxing.capture.camera.AutoFocusManager;
import top.fullj.zxing.capture.camera.CameraConfigure;
import top.fullj.zxing.capture.camera.OpenCamera;
import top.fullj.zxing.capture.camera.PreviewCallback;

public final class CameraManager {
    private static final Logger LOG = LoggerFactory.getLogger(CameraManager.class);
    private static final int MIN_FRAME_WIDTH = 240;
    private static final int MIN_FRAME_HEIGHT = 240;
    private static final int MAX_FRAME_WIDTH = 1200;
    private static final int MAX_FRAME_HEIGHT = 675;
    private final CameraConfigure configure;
    private OpenCamera camera;
    private AutoFocusManager autoFocusManager;
    private Rect framingRect;
    private Rect framingRectInPreview;
    private boolean initialized;
    private boolean previewing;
    private int requestedCameraId = -1;
    private int requestedFramingRectWidth;
    private int requestedFramingRectHeight;
    private final PreviewCallback previewCallback;

    public CameraManager(CaptureActivity activity) {
        this.configure = new CameraConfigure(activity);
        this.previewCallback = new PreviewCallback(this.configure);
    }

    public synchronized void openDriver(SurfaceHolder holder) throws IOException {
        Camera cameraObject;
        block8: {
            Camera.Parameters parameters;
            OpenCamera theCamera = this.camera;
            if (theCamera == null) {
                theCamera = OpenCamera.open(this.requestedCameraId);
                if (theCamera == null) {
                    throw new IOException("Camera.open() failed to return object from driver");
                }
                LOG.info("Opened {}", (Object)theCamera);
                this.camera = theCamera;
            }
            if (!this.initialized) {
                this.initialized = true;
                this.configure.initFromCameraParameters(theCamera);
                if (this.requestedFramingRectWidth > 0 && this.requestedFramingRectHeight > 0) {
                    this.setManualFramingRect(this.requestedFramingRectWidth, this.requestedFramingRectHeight);
                    this.requestedFramingRectWidth = 0;
                    this.requestedFramingRectHeight = 0;
                }
            }
            String parametersFlattened = (parameters = (cameraObject = theCamera.getCamera()).getParameters()) == null ? null : parameters.flatten();
            try {
                this.configure.setDesiredCameraParameters(theCamera, false);
            }
            catch (RuntimeException re) {
                LOG.warn("Camera rejected parameters. Setting only minimal safe-mode parameters");
                LOG.debug("Resetting to saved camera params: {}", (Object)parametersFlattened);
                if (parametersFlattened == null) break block8;
                parameters = cameraObject.getParameters();
                parameters.unflatten(parametersFlattened);
                try {
                    cameraObject.setParameters(parameters);
                    this.configure.setDesiredCameraParameters(theCamera, true);
                }
                catch (RuntimeException re2) {
                    LOG.warn("Camera rejected even safe-mode parameters! No configuration");
                }
            }
        }
        cameraObject.setPreviewDisplay(holder);
    }

    public synchronized boolean isOpen() {
        return this.camera != null;
    }

    public synchronized void closeDriver() {
        if (this.camera != null) {
            this.camera.getCamera().release();
            LOG.info("Closed {}", (Object)this.camera);
            this.camera = null;
            this.framingRect = null;
            this.framingRectInPreview = null;
        }
    }

    public synchronized void startPreview() {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && !this.previewing) {
            theCamera.getCamera().startPreview();
            this.previewing = true;
            this.autoFocusManager = new AutoFocusManager(theCamera.getCamera());
        }
    }

    public synchronized void stopPreview() {
        if (this.autoFocusManager != null) {
            this.autoFocusManager.stop();
            this.autoFocusManager = null;
        }
        if (this.camera != null && this.previewing) {
            this.camera.getCamera().stopPreview();
            this.previewCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public synchronized void setTorch(boolean newSetting) {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && newSetting != this.configure.getTorchState(theCamera.getCamera())) {
            boolean wasAutoFocusManager;
            boolean bl = wasAutoFocusManager = this.autoFocusManager != null;
            if (wasAutoFocusManager) {
                this.autoFocusManager.stop();
                this.autoFocusManager = null;
            }
            this.configure.setTorch(theCamera.getCamera(), newSetting);
            if (wasAutoFocusManager) {
                this.autoFocusManager = new AutoFocusManager(theCamera.getCamera());
                this.autoFocusManager.start();
            }
        }
    }

    public synchronized void requestPreviewFrame(Handler handler, int message) {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && this.previewing) {
            this.previewCallback.setHandler(handler, message);
            theCamera.getCamera().setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
        }
    }

    public synchronized Rect getFramingRect() {
        if (this.framingRect == null) {
            if (this.camera == null) {
                return null;
            }
            Point screenResolution = this.configure.getScreenResolution();
            if (screenResolution == null) {
                return null;
            }
            int width = CameraManager.findDesiredDimensionInRange(screenResolution.x, 240, 1200);
            int height = CameraManager.findDesiredDimensionInRange(screenResolution.y, 240, 675);
            width = height = Math.min(width, height);
            int leftOffset = (screenResolution.x - width) / 2;
            int topOffset = (screenResolution.y - height) / 2;
            this.framingRect = new Rect(leftOffset, topOffset, leftOffset + width, topOffset + height);
            LOG.debug("Calculated framing rect: {}", (Object)this.framingRect);
        }
        return this.framingRect;
    }

    private static int findDesiredDimensionInRange(int resolution, int hardMin, int hardMax) {
        int dim = 5 * resolution / 8;
        if (dim < hardMin) {
            return hardMin;
        }
        if (dim > hardMax) {
            return hardMax;
        }
        return dim;
    }

    public synchronized Rect getFramingRectInPreview() {
        if (this.framingRectInPreview == null) {
            Rect framingRect = this.getFramingRect();
            if (framingRect == null) {
                return null;
            }
            Rect rect = new Rect(framingRect);
            Point cameraResolution = this.configure.getCameraResolution();
            Point screenResolution = this.configure.getScreenResolution();
            if (cameraResolution == null || screenResolution == null) {
                return null;
            }
            if (screenResolution.x < screenResolution.y) {
                rect.left = rect.left * cameraResolution.y / screenResolution.x;
                rect.right = rect.right * cameraResolution.y / screenResolution.x;
                rect.top = rect.top * cameraResolution.x / screenResolution.y;
                rect.bottom = rect.bottom * cameraResolution.x / screenResolution.y;
            } else {
                rect.left = rect.left * cameraResolution.x / screenResolution.x;
                rect.right = rect.right * cameraResolution.x / screenResolution.x;
                rect.top = rect.top * cameraResolution.y / screenResolution.y;
                rect.bottom = rect.bottom * cameraResolution.y / screenResolution.y;
            }
            this.framingRectInPreview = rect;
        }
        return this.framingRectInPreview;
    }

    public synchronized void setManualCameraId(int cameraId) {
        this.requestedCameraId = cameraId;
    }

    public synchronized void setManualFramingRect(int width, int height) {
        if (this.initialized) {
            Point screenResolution = this.configure.getScreenResolution();
            if (width > screenResolution.x) {
                width = screenResolution.x;
            }
            if (height > screenResolution.y) {
                height = screenResolution.y;
            }
            int leftOffset = (screenResolution.x - width) / 2;
            int topOffset = (screenResolution.y - height) / 2;
            this.framingRect = new Rect(leftOffset, topOffset, leftOffset + width, topOffset + height);
            LOG.debug("Calculated manual framing rect: {}", (Object)this.framingRect);
            this.framingRectInPreview = null;
        } else {
            this.requestedFramingRectWidth = width;
            this.requestedFramingRectHeight = height;
        }
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] data, int width, int height) {
        Rect rect = this.getFramingRectInPreview();
        if (rect == null) {
            return null;
        }
        return new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height(), false);
    }
}

