/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture.camera;

import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.camera.CameraConfigure;

final class CameraConfigureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CameraConfigure.class);
    private static final int MIN_PREVIEW_PIXELS = 153600;
    private static final float MAX_EXPOSURE_COMPENSATION = 1.5f;
    private static final float MIN_EXPOSURE_COMPENSATION = 0.0f;
    private static final double MAX_ASPECT_DISTORTION = 0.15;
    private static final int AREA_PER_1000 = 400;

    private CameraConfigureUtils() {
    }

    static void setFocus(Camera.Parameters parameters, boolean autoFocus, boolean disableContinuous, boolean safeMode) {
        List supportedFocusModes = parameters.getSupportedFocusModes();
        String focusMode = null;
        if (autoFocus) {
            focusMode = safeMode || disableContinuous ? CameraConfigureUtils.findSettableValue("focus mode", supportedFocusModes, "auto") : CameraConfigureUtils.findSettableValue("focus mode", supportedFocusModes, "continuous-picture", "continuous-video", "auto");
        }
        if (!safeMode && focusMode == null) {
            focusMode = CameraConfigureUtils.findSettableValue("focus mode", supportedFocusModes, "macro", "edof");
        }
        if (focusMode != null) {
            if (focusMode.equals(parameters.getFocusMode())) {
                LOG.debug("Focus mode already set to {}", (Object)focusMode);
            } else {
                parameters.setFocusMode(focusMode);
            }
        }
    }

    static void setTorch(Camera.Parameters parameters, boolean on) {
        List supportedFlashModes = parameters.getSupportedFlashModes();
        String flashMode = on ? CameraConfigureUtils.findSettableValue("flash mode", supportedFlashModes, "torch", "on") : CameraConfigureUtils.findSettableValue("flash mode", supportedFlashModes, "off");
        if (flashMode != null) {
            if (flashMode.equals(parameters.getFlashMode())) {
                LOG.debug("Flash mode already set to {}", (Object)flashMode);
            } else {
                LOG.info("Setting flash mode to {}", (Object)flashMode);
                parameters.setFlashMode(flashMode);
            }
        }
    }

    static void setBestExposure(Camera.Parameters parameters, boolean lightOn) {
        int minExposure = parameters.getMinExposureCompensation();
        int maxExposure = parameters.getMaxExposureCompensation();
        float step = parameters.getExposureCompensationStep();
        if ((minExposure != 0 || maxExposure != 0) && step > 0.0f) {
            float targetCompensation = lightOn ? 0.0f : 1.5f;
            int compensationSteps = Math.round(targetCompensation / step);
            float actualCompensation = step * (float)compensationSteps;
            compensationSteps = Math.max(Math.min(compensationSteps, maxExposure), minExposure);
            if (parameters.getExposureCompensation() == compensationSteps) {
                LOG.debug("Exposure compensation already set to {} / {}", (Object)compensationSteps, (Object)Float.valueOf(actualCompensation));
            } else {
                LOG.info("Setting exposure compensation to {} / {}", (Object)compensationSteps, (Object)Float.valueOf(actualCompensation));
                parameters.setExposureCompensation(compensationSteps);
            }
        } else {
            LOG.info("Camera does not support exposure compensation");
        }
    }

    static void setFocusArea(Camera.Parameters parameters) {
        if (parameters.getMaxNumFocusAreas() > 0) {
            LOG.debug("Old focus areas: {}", (Object)CameraConfigureUtils.toString(parameters.getFocusAreas()));
            List<Camera.Area> middleArea = CameraConfigureUtils.buildMiddleArea(400);
            LOG.info("Setting focus area to : {}", (Object)CameraConfigureUtils.toString(middleArea));
            parameters.setFocusAreas(middleArea);
        } else {
            LOG.info("Device does not support focus areas");
        }
    }

    static void setMetering(Camera.Parameters parameters) {
        if (parameters.getMaxNumMeteringAreas() > 0) {
            LOG.debug("Old metering areas: {}", (Object)parameters.getMeteringAreas());
            List<Camera.Area> middleArea = CameraConfigureUtils.buildMiddleArea(400);
            LOG.info("Setting metering area to : {}", (Object)CameraConfigureUtils.toString(middleArea));
            parameters.setMeteringAreas(middleArea);
        } else {
            LOG.info("Device does not support metering areas");
        }
    }

    private static List<Camera.Area> buildMiddleArea(int areaPer1000) {
        return Collections.singletonList(new Camera.Area(new Rect(-areaPer1000, -areaPer1000, areaPer1000, areaPer1000), 1));
    }

    static void setVideoStabilization(Camera.Parameters parameters) {
        if (parameters.isVideoStabilizationSupported()) {
            if (parameters.getVideoStabilization()) {
                LOG.debug("Video stabilization already enabled");
            } else {
                LOG.info("Enabling video stabilization...");
                parameters.setVideoStabilization(true);
            }
        } else {
            LOG.info("This device does not support video stabilization");
        }
    }

    static void setBarcodeSceneMode(Camera.Parameters parameters) {
        if ("barcode".equals(parameters.getSceneMode())) {
            LOG.debug("Barcode scene mode already set");
            return;
        }
        String sceneMode = CameraConfigureUtils.findSettableValue("scene mode", parameters.getSupportedSceneModes(), "barcode");
        if (sceneMode != null) {
            parameters.setSceneMode(sceneMode);
        }
    }

    public static void setZoom(Camera.Parameters parameters, double targetZoomRatio) {
        if (parameters.isZoomSupported()) {
            Integer zoom = CameraConfigureUtils.indexOfClosestZoom(parameters, targetZoomRatio);
            if (zoom == null) {
                return;
            }
            if (parameters.getZoom() == zoom.intValue()) {
                LOG.debug("Zoom is already set to {}", (Object)zoom);
            } else {
                LOG.info("Setting zoom to {}", (Object)zoom);
                parameters.setZoom(zoom.intValue());
            }
        } else {
            LOG.info("Zoom is not supported");
        }
    }

    private static Integer indexOfClosestZoom(Camera.Parameters parameters, double targetZoomRatio) {
        List ratios = parameters.getZoomRatios();
        LOG.info("Zoom ratios: {}", (Object)ratios);
        int maxZoom = parameters.getMaxZoom();
        if (ratios == null || ratios.isEmpty() || ratios.size() != maxZoom + 1) {
            LOG.warn("Invalid zoom ratios!");
            return null;
        }
        double target100 = 100.0 * targetZoomRatio;
        double smallestDiff = Double.POSITIVE_INFINITY;
        int closestIndex = 0;
        for (int i = 0; i < ratios.size(); ++i) {
            double diff = Math.abs((double)((Integer)ratios.get(i)).intValue() - target100);
            if (!(diff < smallestDiff)) continue;
            smallestDiff = diff;
            closestIndex = i;
        }
        LOG.info("Chose zoom ratio of {}", (Object)((double)((Integer)ratios.get(closestIndex)).intValue() / 100.0));
        return closestIndex;
    }

    static void setInvertColor(Camera.Parameters parameters) {
        if ("negative".equals(parameters.getColorEffect())) {
            LOG.info("Negative effect already set");
            return;
        }
        String colorMode = CameraConfigureUtils.findSettableValue("color effect", parameters.getSupportedColorEffects(), "negative");
        if (colorMode != null) {
            parameters.setColorEffect(colorMode);
        }
    }

    static Point findBestPreviewSizeValue(Camera.Parameters parameters, Point screenResolution) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            LOG.debug("Device returned no supported preview sizes; using default");
            Camera.Size defaultSize = parameters.getPreviewSize();
            if (defaultSize == null) {
                throw new IllegalStateException("Parameters contained no preview size!");
            }
            return new Point(defaultSize.width, defaultSize.height);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder previewSizesString = new StringBuilder();
            for (Camera.Size size : rawSupportedSizes) {
                previewSizesString.append(size.width).append('x').append(size.height).append(' ');
            }
            LOG.debug("Supported preview sizes: {}", (Object)previewSizesString);
        }
        double screenAspectRatio = (double)screenResolution.x / (double)screenResolution.y;
        int maxResolution = 0;
        Camera.Size maxResPreviewSize = null;
        for (Camera.Size size : rawSupportedSizes) {
            int maybeFlippedHeight;
            boolean isCandidatePortrait;
            int maybeFlippedWidth;
            double aspectRatio;
            double distortion;
            int realWidth = size.width;
            int realHeight = size.height;
            int resolution = realWidth * realHeight;
            if (resolution < 153600 || (distortion = Math.abs((aspectRatio = (double)(maybeFlippedWidth = (isCandidatePortrait = realWidth < realHeight) ? realHeight : realWidth) / (double)(maybeFlippedHeight = isCandidatePortrait ? realWidth : realHeight)) - screenAspectRatio)) > 0.15) continue;
            if (maybeFlippedWidth == screenResolution.x && maybeFlippedHeight == screenResolution.y) {
                Point exactPoint = new Point(realWidth, realHeight);
                LOG.debug("Found preview size exactly matching screen size: {}", (Object)exactPoint);
                return exactPoint;
            }
            if (resolution <= maxResolution) continue;
            maxResolution = resolution;
            maxResPreviewSize = size;
        }
        if (maxResPreviewSize != null) {
            Point largestSize = new Point(maxResPreviewSize.width, maxResPreviewSize.height);
            LOG.debug("Using largest suitable preview size: {}", (Object)largestSize);
            return largestSize;
        }
        Camera.Size defaultPreview = parameters.getPreviewSize();
        if (defaultPreview == null) {
            throw new IllegalStateException("Parameters contained no preview size!");
        }
        Point defaultSize = new Point(defaultPreview.width, defaultPreview.height);
        LOG.debug("No suitable preview sizes, using default: {}", (Object)defaultSize);
        return defaultSize;
    }

    private static String findSettableValue(String name, Collection<String> supportedValues, String ... desiredValues) {
        LOG.debug("{} supported: {}, requesting: {}", new Object[]{name, supportedValues, desiredValues});
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                LOG.trace("Can set {} to: {}", (Object)name, (Object)desiredValue);
                return desiredValue;
            }
        }
        LOG.trace("{}: no supported values match", (Object)name);
        return null;
    }

    private static String toString(Iterable<Camera.Area> areas) {
        if (areas == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Camera.Area area : areas) {
            result.append(area.rect).append(':').append(area.weight).append(' ');
        }
        return result.toString();
    }
}

