/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture.camera;

import android.graphics.Point;
import android.hardware.Camera;
import android.view.Display;
import android.view.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.CaptureActivity;
import top.fullj.zxing.capture.CaptureOptions;
import top.fullj.zxing.capture.camera.CameraConfigureUtils;
import top.fullj.zxing.capture.camera.FrontLightMode;
import top.fullj.zxing.capture.camera.OpenCamera;

final class CameraConfigure {
    private static final Logger LOG = LoggerFactory.getLogger(CameraConfigure.class);
    private final CaptureActivity activity;
    private int cwNeededRotation;
    private int cwRotationFromDisplayToCamera;
    private Point screenResolution;
    private Point cameraResolution;
    private Point bestPreviewSize;
    private Point previewSizeOnScreen;

    CameraConfigure(CaptureActivity activity) {
        this.activity = activity;
    }

    void initFromCameraParameters(OpenCamera camera) {
        int cwRotationFromNaturalToDisplay;
        Camera.Parameters parameters = camera.getCamera().getParameters();
        WindowManager manager = (WindowManager)this.activity.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        int displayRotation = display.getRotation();
        switch (displayRotation) {
            case 0: {
                cwRotationFromNaturalToDisplay = 0;
                break;
            }
            case 1: {
                cwRotationFromNaturalToDisplay = 90;
                break;
            }
            case 2: {
                cwRotationFromNaturalToDisplay = 180;
                break;
            }
            case 3: {
                cwRotationFromNaturalToDisplay = 270;
                break;
            }
            default: {
                if (displayRotation % 90 == 0) {
                    cwRotationFromNaturalToDisplay = (360 + displayRotation) % 360;
                    break;
                }
                throw new IllegalArgumentException("Bad rotation: " + displayRotation);
            }
        }
        LOG.debug("Display rotation at: {}", (Object)cwRotationFromNaturalToDisplay);
        int cwRotationFromNaturalToCamera = camera.getOrientation();
        LOG.debug("Camera rotation at: {}", (Object)cwRotationFromNaturalToCamera);
        if (camera.isFront()) {
            cwRotationFromNaturalToCamera = (360 - cwRotationFromNaturalToCamera) % 360;
            LOG.debug("Front camera rotation overridden to: {}", (Object)cwRotationFromNaturalToCamera);
        }
        this.cwRotationFromDisplayToCamera = (360 + cwRotationFromNaturalToCamera - cwRotationFromNaturalToDisplay) % 360;
        LOG.debug("Final display orientation: {}", (Object)this.cwRotationFromDisplayToCamera);
        if (camera.isFront()) {
            LOG.debug("Compensating rotation for front camera");
            this.cwNeededRotation = (360 - this.cwRotationFromDisplayToCamera) % 360;
        } else {
            this.cwNeededRotation = this.cwRotationFromDisplayToCamera;
        }
        LOG.info("Clockwise rotation from display to camera: {}", (Object)this.cwNeededRotation);
        Point theScreenResolution = new Point();
        display.getSize(theScreenResolution);
        this.screenResolution = theScreenResolution;
        LOG.debug("Screen resolution in current orientation: {}", (Object)this.screenResolution);
        this.cameraResolution = CameraConfigureUtils.findBestPreviewSizeValue(parameters, this.screenResolution);
        LOG.debug("Camera resolution: {}", (Object)this.cameraResolution);
        this.bestPreviewSize = CameraConfigureUtils.findBestPreviewSizeValue(parameters, this.screenResolution);
        LOG.debug("Best available preview size: {}", (Object)this.bestPreviewSize);
        boolean isScreenPortrait = this.screenResolution.x < this.screenResolution.y;
        boolean isPreviewSizePortrait = this.bestPreviewSize.x < this.bestPreviewSize.y;
        this.previewSizeOnScreen = isScreenPortrait == isPreviewSizePortrait ? this.bestPreviewSize : new Point(this.bestPreviewSize.y, this.bestPreviewSize.x);
        LOG.info("Preview size on screen: {}", (Object)this.previewSizeOnScreen);
    }

    void setDesiredCameraParameters(OpenCamera camera, boolean safeMode) {
        Camera theCamera = camera.getCamera();
        Camera.Parameters parameters = theCamera.getParameters();
        if (parameters == null) {
            LOG.warn("Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        LOG.debug("Initial camera parameters: {}", (Object)parameters.flatten());
        if (safeMode) {
            LOG.warn("In camera config safe mode -- most settings will not be honored");
        }
        this.initializeTorch(parameters, safeMode);
        CameraConfigureUtils.setFocus(parameters, CaptureOptions.AUTO_FOCUS, CaptureOptions.DISABLE_CONTINUOUS_FOCUS, safeMode);
        if (!safeMode) {
            if (CaptureOptions.INVERT_SCAN) {
                CameraConfigureUtils.setInvertColor(parameters);
            }
            if (!CaptureOptions.DISABLE_BARCODE_SCENE_MODE) {
                CameraConfigureUtils.setBarcodeSceneMode(parameters);
            }
            if (!CaptureOptions.DISABLE_METERING) {
                CameraConfigureUtils.setVideoStabilization(parameters);
                CameraConfigureUtils.setFocusArea(parameters);
                CameraConfigureUtils.setMetering(parameters);
            }
            parameters.setRecordingHint(true);
        }
        parameters.setPreviewSize(this.bestPreviewSize.x, this.bestPreviewSize.y);
        theCamera.setParameters(parameters);
        theCamera.setDisplayOrientation(this.cwRotationFromDisplayToCamera);
        Camera.Parameters afterParameters = theCamera.getParameters();
        Camera.Size afterSize = afterParameters.getPreviewSize();
        if (afterSize != null && (this.bestPreviewSize.x != afterSize.width || this.bestPreviewSize.y != afterSize.height)) {
            LOG.warn("Camera said it supported preview size {}x{}, but after setting it, preview size is {}x{}", new Object[]{this.bestPreviewSize.x, this.bestPreviewSize.y, afterSize.width, afterSize.height});
            this.bestPreviewSize.x = afterSize.width;
            this.bestPreviewSize.y = afterSize.height;
        }
    }

    Point getPreviewSizeOnScreen() {
        return this.previewSizeOnScreen;
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    int getCWNeededRotation() {
        return this.cwNeededRotation;
    }

    boolean getTorchState(Camera camera) {
        Camera.Parameters parameters;
        if (camera != null && (parameters = camera.getParameters()) != null) {
            String flashMode = parameters.getFlashMode();
            return "on".equals(flashMode) || "torch".equals(flashMode);
        }
        return false;
    }

    void setTorch(Camera camera, boolean newSetting) {
        Camera.Parameters parameters = camera.getParameters();
        this.doSetTorch(parameters, newSetting, false);
        camera.setParameters(parameters);
    }

    private void initializeTorch(Camera.Parameters parameters, boolean safeMode) {
        this.doSetTorch(parameters, CaptureOptions.FRONT_LIGHT_MODE == FrontLightMode.ON, safeMode);
    }

    private void doSetTorch(Camera.Parameters parameters, boolean newSetting, boolean safeMode) {
        CameraConfigureUtils.setTorch(parameters, newSetting);
        if (!safeMode && !CaptureOptions.DISABLE_EXPOSURE) {
            CameraConfigureUtils.setBestExposure(parameters, newSetting);
        }
    }
}

