/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.app.Activity;
import android.os.AsyncTask;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.CaptureActivity;

final class InactivityTimer {
    private static final Logger LOG = LoggerFactory.getLogger(InactivityTimer.class);
    private static final long INACTIVITY_DELAY_MS = 180000L;
    private final Activity activity;
    private AsyncTask<Object, Object, Object> inactivityTask;

    InactivityTimer(Activity activity) {
        this.activity = activity;
    }

    synchronized void onActivity() {
        this.cancel();
        this.inactivityTask = new InactivityAsyncTask();
        try {
            this.inactivityTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[]{this.activity});
        }
        catch (RejectedExecutionException ree) {
            LOG.warn("Couldn't schedule inactivity task; ignoring", (Throwable)ree);
        }
    }

    synchronized void onPause() {
    }

    synchronized void onResume() {
        this.onActivity();
    }

    private synchronized void cancel() {
        AsyncTask<Object, Object, Object> task = this.inactivityTask;
        if (task != null) {
            task.cancel(true);
            this.inactivityTask = null;
        }
    }

    void shutdown() {
        this.cancel();
    }

    private static final class InactivityAsyncTask
    extends AsyncTask<Object, Object, Object> {
        private InactivityAsyncTask() {
        }

        protected Object doInBackground(Object ... objects) {
            CaptureActivity activity = (CaptureActivity)((Object)objects[0]);
            try {
                Thread.sleep(180000L);
                LOG.warn("Cancelled scan due to inactivity");
                activity.runOnUiThread(activity::cancel);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
    }
}

