/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.os.Handler;
import android.os.Looper;
import com.google.zxing.DecodeHintType;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import top.fullj.zxing.capture.CaptureActivity;
import top.fullj.zxing.capture.DecodeHandler;

final class DecodeThread
extends Thread {
    static final String BARCODE_BITMAP = "barcode_bitmap";
    static final String BARCODE_SCALED_FACTOR = "barcode_scaled_factor";
    private final CaptureActivity activity;
    private final Map<DecodeHintType, Object> hints;
    private Handler handler;
    private final CountDownLatch handlerInitLatch;

    DecodeThread(CaptureActivity activity) {
        this.activity = activity;
        this.handlerInitLatch = new CountDownLatch(1);
        this.hints = activity.getHints();
    }

    Handler getHandler() {
        try {
            this.handlerInitLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.handler;
    }

    @Override
    public void run() {
        Looper.prepare();
        this.handler = new DecodeHandler(this.activity, this.hints);
        this.handlerInitLatch.countDown();
        Looper.loop();
    }
}

