/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.content.Intent;
import android.os.Bundle;
import com.google.zxing.DecodeHintType;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DecodeHintManager {
    private static final Logger LOG = LoggerFactory.getLogger(DecodeHintManager.class);

    private DecodeHintManager() {
    }

    static Map<DecodeHintType, Object> parseDecodeHints(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null || extras.isEmpty()) {
            return null;
        }
        EnumMap<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        for (DecodeHintType hintType : DecodeHintType.values()) {
            String hintName;
            if (hintType == DecodeHintType.CHARACTER_SET || hintType == DecodeHintType.NEED_RESULT_POINT_CALLBACK || hintType == DecodeHintType.POSSIBLE_FORMATS || !extras.containsKey(hintName = hintType.name())) continue;
            if (hintType.getValueType().equals(Void.class)) {
                hints.put(hintType, (Object)Boolean.TRUE);
                continue;
            }
            Object hintData = extras.get(hintName);
            if (hintType.getValueType().isInstance(hintData)) {
                hints.put(hintType, hintData);
                continue;
            }
            LOG.warn("Ignoring hint {} because it is not a {}", (Object)hintType, (Object)hintType.getValueType());
        }
        return hints;
    }
}

